/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.displays.spice;

import com.lance5057.extradelight.displays.spice.SpiceRackBlock;
import com.lance5057.extradelight.displays.spice.SpiceRackEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class SpiceRackRenderer
implements BlockEntityRenderer<SpiceRackEntity> {
    public SpiceRackRenderer(BlockEntityRendererProvider.Context cxt) {
    }

    public void render(SpiceRackEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (!pBlockEntity.hasLevel()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        IItemHandler r = pBlockEntity.getItemHandler();
        Direction dir = (Direction)pBlockEntity.getBlockState().getValue((Property)SpiceRackBlock.FACING);
        this.renderItem(0, pBlockEntity, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, itemRenderer, r, dir, 0.2f, 0.55f, 0.15f, 0.0f, 0.0f, 0.0f);
        this.renderItem(1, pBlockEntity, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, itemRenderer, r, dir, 0.4f, 0.55f, 0.125f, 0.0f, 0.0f, 0.0f);
        this.renderItem(2, pBlockEntity, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, itemRenderer, r, dir, 0.6f, 0.55f, 0.15f, 0.0f, 0.0f, 0.0f);
        this.renderItem(3, pBlockEntity, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, itemRenderer, r, dir, 0.8f, 0.55f, 0.125f, 0.0f, 0.0f, 0.0f);
    }

    private void renderItem(int slot, SpiceRackEntity pBlockEntity, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, ItemRenderer itemRenderer, @NotNull IItemHandler r, Direction dir, float x, float y, float z, float rx, float ry, float rz) {
        pPoseStack.pushPose();
        ItemStack item = r.getStackInSlot(slot);
        if (!item.isEmpty()) {
            BakedModel bakedmodel = itemRenderer.getModel(item, pBlockEntity.getLevel(), null, 0);
            pPoseStack.pushPose();
            float uniscale = 0.75f;
            pPoseStack.translate(0.5f, 0.0f, 0.5f);
            pPoseStack.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(-dir.toYRot()), 0.0f));
            pPoseStack.translate(x - 0.5f, y, z - 0.5f);
            pPoseStack.mulPose(new Quaternionf().rotateXYZ((float)Math.toRadians(rx), (float)Math.toRadians(ry), (float)Math.toRadians(rz)));
            pPoseStack.scale(uniscale, uniscale, uniscale);
            itemRenderer.render(item, ItemDisplayContext.GROUND, false, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, bakedmodel);
            pPoseStack.popPose();
        }
        pPoseStack.popPose();
    }

    public boolean shouldRenderOffScreen(SpiceRackEntity pBlockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 64;
    }

    public boolean shouldRender(SpiceRackEntity pBlockEntity, Vec3 pCameraPos) {
        return true;
    }
}

