/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.gui;

import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.FancyTank;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FancyTankInSlot
extends SlotItemHandler {
    FancyTank tank;

    public FancyTankInSlot(IItemHandler itemHandler, FancyTank tank, int index, int xPosition, int yPosition) {
        super(itemHandler, index, xPosition, yPosition);
        this.tank = tank;
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.calcFluidInSlotSize(stack);
    }

    private int calcFluidInSlotSize(ItemStack pSlot) {
        if (pSlot.getCapability(Capabilities.FluidHandler.ITEM) != null && pSlot.getItem() != Items.BUCKET) {
            if (((IFluidHandlerItem)pSlot.getCapability(Capabilities.FluidHandler.ITEM)).getFluidInTank(0).isEmpty()) {
                return 0;
            }
            return 1;
        }
        if (!BottleFluidRegistry.getFluidFromBottle(pSlot).isEmpty()) {
            return this.tank.getVacancy() / 250;
        }
        return 0;
    }
}

