/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.gui;

import com.lance5057.extradelight.ExtraDelightContainers;
import com.lance5057.extradelight.blocks.interfaces.IStyleable;
import com.lance5057.extradelight.network.StyleableMenuSyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class StyleableMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    public BlockPos pos;
    private final Player player;

    public StyleableMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory);
    }

    public StyleableMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.NULL, BlockPos.ZERO);
    }

    public StyleableMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess, BlockPos pos) {
        super(ExtraDelightContainers.STYLE_MENU.get(), pContainerId);
        this.access = pAccess;
        this.pos = pos;
        this.player = pPlayerInventory.player;
    }

    public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
        return null;
    }

    public boolean stillValid(Player p_38874_) {
        return true;
    }

    public boolean clickMenuButton(Player p_39465_, int p_39466_) {
        this.access.execute((level, pos) -> {
            BlockState state = level.getBlockState(pos);
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof IStyleable) {
                IStyleable s = (IStyleable)patt0$temp;
                switch (p_39466_) {
                    case 0: {
                        s.setNextStyle((Level)level, (BlockPos)pos, state);
                        break;
                    }
                    case 1: {
                        s.setPrevStyle((Level)level, (BlockPos)pos, state);
                        break;
                    }
                    default: {
                        s.setStyle((Level)level, (BlockPos)pos, state, p_39466_ - 2);
                    }
                }
            }
        });
        return true;
    }

    private BlockState getState(Level level, BlockPos pos) {
        return level.getBlockState(pos);
    }

    public void sendAllDataToRemote() {
        super.sendAllDataToRemote();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((CustomPacketPayload)new StyleableMenuSyncPacket(this.containerId, this.pos));
        }
    }
}

