/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.gui.widgets;

import com.lance5057.extradelight.workstations.FancyTank;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class FancyTankWidget
extends AbstractWidget {
    private final Supplier<FancyTank> getFluid;

    public FancyTankWidget(int x, int y, int width, int height, Supplier<FancyTank> getFluid) {
        super(x, y, width, height, (Component)Component.empty());
        this.getFluid = getFluid;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        FancyTank fluidTank = this.getFluid.get();
        int offset = 0;
        for (int tank = 0; tank < fluidTank.getTanks(); ++tank) {
            AbstractTexture texture;
            FluidStack fluidStack;
            IClientFluidTypeExtensions props;
            ResourceLocation still;
            if (!fluidTank.isEmpty(tank) && (still = (props = IClientFluidTypeExtensions.of((Fluid)(fluidStack = fluidTank.getFluid(tank)).getFluid())).getStillTexture(fluidStack)) != null && (texture = minecraft.getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS)) instanceof TextureAtlas) {
                TextureAtlas atlas = (TextureAtlas)texture;
                TextureAtlasSprite sprite = atlas.getSprite(still);
                int color = props.getTintColor();
                RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.red((int)color) / 255.0f), (float)((float)FastColor.ARGB32.green((int)color) / 255.0f), (float)((float)FastColor.ARGB32.blue((int)color) / 255.0f), (float)((float)FastColor.ARGB32.alpha((int)color) / 255.0f));
                RenderSystem.enableBlend();
                int stored = fluidTank.getFluidAmount(tank);
                float capacity = fluidTank.getCapacity(tank);
                float filledVolume = (float)stored / capacity;
                int renderableHeight = (int)((double)filledVolume * Math.ceil((float)this.height / (float)fluidTank.getVarietyCap()));
                int atlasWidth = (int)((float)sprite.contents().width() / (sprite.getU1() - sprite.getU0()));
                int atlasHeight = (int)((float)sprite.contents().height() / (sprite.getV1() - sprite.getV0()));
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, (float)(this.height - 16 + offset), 0.0f);
                int i = 0;
                while ((double)i < Math.ceil((float)renderableHeight / 16.0f)) {
                    int drawingHeight = Math.min(16, renderableHeight - 16 * i);
                    int notDrawingHeight = 16 - drawingHeight;
                    guiGraphics.blit(TextureAtlas.LOCATION_BLOCKS, this.getX(), this.getY() + notDrawingHeight, 0, sprite.getU0() * (float)atlasWidth, sprite.getV0() * (float)atlasHeight + (float)notDrawingHeight, this.width, drawingHeight, atlasWidth, atlasHeight);
                    guiGraphics.pose().translate(0.0f, -16.0f, 0.0f);
                    ++i;
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                offset -= renderableHeight;
                guiGraphics.pose().popPose();
            }
            this.renderToolTip(guiGraphics, mouseX, mouseY);
        }
        RenderSystem.disableDepthTest();
    }

    public void renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isHovered(mouseX, mouseY)) {
            Minecraft minecraft = Minecraft.getInstance();
            FancyTank fluidTank = this.getFluid.get();
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            if (!fluidTank.isEmpty(5)) {
                list.add(fluidTank.getFluid(5).getDisplayName().getVisualOrderText());
                list.add(Component.literal((String)(" - " + fluidTank.getFluidAmount(5) + "mB")).withColor(0x999999).getVisualOrderText());
            }
            if (!fluidTank.isEmpty(4)) {
                list.add(fluidTank.getFluid(4).getDisplayName().getVisualOrderText());
                list.add(Component.literal((String)(" - " + fluidTank.getFluidAmount(4) + "mB")).withColor(0x999999).getVisualOrderText());
            }
            if (!fluidTank.isEmpty(3)) {
                list.add(fluidTank.getFluid(3).getDisplayName().getVisualOrderText());
                list.add(Component.literal((String)(" - " + fluidTank.getFluidAmount(3) + "mB")).withColor(0x999999).getVisualOrderText());
            }
            if (!fluidTank.isEmpty(2)) {
                list.add(fluidTank.getFluid(2).getDisplayName().getVisualOrderText());
                list.add(Component.literal((String)(" - " + fluidTank.getFluidAmount(2) + "mB")).withColor(0x999999).getVisualOrderText());
            }
            if (!fluidTank.isEmpty(1)) {
                list.add(fluidTank.getFluid(1).getDisplayName().getVisualOrderText());
                list.add(Component.literal((String)(" - " + fluidTank.getFluidAmount(1) + "mB")).withColor(0x999999).getVisualOrderText());
            }
            if (!fluidTank.isEmpty(0)) {
                list.add(fluidTank.getFluid(0).getDisplayName().getVisualOrderText());
                list.add(Component.literal((String)(" - " + fluidTank.getFluidAmount(0) + "mB")).withColor(0x999999).getVisualOrderText());
            }
            guiGraphics.renderTooltip(minecraft.font, list, mouseX, mouseY);
        }
    }

    protected boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

