/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.integration.jei.categories;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.ExtraDelightTags;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.chiller.ChillerRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ChillerRecipeCategory
implements IRecipeCategory<ChillerRecipe> {
    public static final RecipeType<ChillerRecipe> TYPE = RecipeType.create((String)"extradelight", (String)"chiller", ChillerRecipe.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public ChillerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/jei.png"), 132, 0, 124, 73);
        this.localizedName = Component.translatable((String)"extradelight.jei.chiller");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ExtraDelightItems.CHILLER.get()));
    }

    public RecipeType<ChillerRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ChillerRecipe recipe, IFocusGroup focuses) {
        for (int i = 0; i < recipe.getIngredients().size(); ++i) {
            if (i < 2) {
                builder.addSlot(RecipeIngredientRole.INPUT, 45 + i % 2 * 18, 20).addIngredients((Ingredient)recipe.getIngredients().get(i));
                continue;
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 45 + i % 2 * 18, 38).addIngredients((Ingredient)recipe.getIngredients().get(i));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, this.getWidth() / 2 - 38, 1).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, List.of(recipe.getFluid()))).setFluidRenderer(1000L, false, 16, 71);
        builder.addSlot(RecipeIngredientRole.INPUT, 54, 56).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{recipe.getOutputContainer()}));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 107, 30).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{recipe.output}));
        builder.addSlot(RecipeIngredientRole.CATALYST, 1, 1).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{BottleFluidRegistry.getBottleFromFluidWithoutSize(recipe.getFluid().getFluid()), new ItemStack((ItemLike)recipe.getFluid().getFluid().getBucket())}));
        builder.addSlot(RecipeIngredientRole.CATALYST, 107, 9).addIngredients(Ingredient.of(ExtraDelightTags.CHILLING_ITEMS));
    }
}

