/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.integration.jei.categories;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.vat.recipes.VatRecipe;
import java.text.DecimalFormat;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class VatRecipeCategory
implements IRecipeCategory<VatRecipe> {
    public static final RecipeType<VatRecipe> TYPE = RecipeType.create((String)"extradelight", (String)"vat", VatRecipe.class);
    private final IDrawable background;
    private final IDrawable stage;
    private final IDrawable finish;
    private final Component localizedName;
    private final IDrawable icon;

    public VatRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/jei3.png"), 0, 0, 101, 47);
        this.stage = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/jei3.png"), 0, 47, 101, 31);
        this.finish = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/jei3.png"), 0, 78, 101, 33);
        this.localizedName = Component.translatable((String)"extradelight.jei.vat");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ExtraDelightItems.VAT.get()));
    }

    public RecipeType<VatRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 101;
    }

    public int getHeight() {
        return 143;
    }

    public void draw(VatRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        Font fontRenderer = minecraft.font;
        this.background.draw(guiGraphics, 0, 0);
        for (int i = 0; i < recipe.getStages(); ++i) {
            this.stage.draw(guiGraphics, 0, 47 + i * 31);
            guiGraphics.drawString(fontRenderer, (Component)Component.translatable((String)"extradelight.jei.info.vat.stage", (Object[])new Object[]{i + 1}), 0, 49 + i * 31, -1);
            if (((VatRecipe.StageIngredient)recipe.getStageIngredients().get((int)i)).lid) {
                guiGraphics.drawString(fontRenderer, (Component)Component.translatable((String)"extradelight.jei.info.vat.lid.on"), 0, 58 + i * 31, -43691);
            } else {
                guiGraphics.drawString(fontRenderer, (Component)Component.translatable((String)"extradelight.jei.info.vat.lid.off"), 0, 58 + i * 31, -1);
            }
            float f = (float)((VatRecipe.StageIngredient)recipe.getStageIngredients().get((int)i)).time / 24000.0f;
            DecimalFormat df = new DecimalFormat("##.##");
            if (f > 1.0f || f < 1.0f) {
                guiGraphics.drawString(fontRenderer, (Component)Component.translatable((String)"extradelight.jei.info.vat.days", (Object[])new Object[]{df.format(f)}), 0, 67 + i * 31, -1);
                continue;
            }
            guiGraphics.drawString(fontRenderer, (Component)Component.translatable((String)"extradelight.jei.info.vat.day", (Object[])new Object[]{df.format(f)}), 0, 67 + i * 31, -1);
        }
        this.finish.draw(guiGraphics, 0, 46 + recipe.getStages() * 31);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, VatRecipe recipe, IFocusGroup focuses) {
        int i;
        for (i = 0; i < recipe.getIngredients().size(); ++i) {
            if (i < 3) {
                builder.addSlot(RecipeIngredientRole.INPUT, 48 + i % 3 * 18, 1).addIngredients((Ingredient)recipe.getIngredients().get(i));
                continue;
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 48 + i % 3 * 18, 19).addIngredients((Ingredient)recipe.getIngredients().get(i));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, this.getWidth() / 2 - 25, 1).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, List.of(recipe.getFluid().getFluids()))).setFluidRenderer(1000L, false, 16, 34);
        builder.addSlot(RecipeIngredientRole.CATALYST, 1, 10).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{BottleFluidRegistry.getBottleFromFluidWithoutSize(recipe.getFluid().getFluids()[0].getFluid()), new ItemStack((ItemLike)recipe.getFluid().getFluids()[0].getFluid().getBucket())}));
        for (i = 0; i < recipe.getStages(); ++i) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 58, 59 + i * 31).addIngredients(((VatRecipe.StageIngredient)recipe.getStageIngredients().get((int)i)).ingredient);
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 84, recipe.getStages() * 31 + 62).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{recipe.getUsedItem()}));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 58, recipe.getStages() * 31 + 62).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{recipe.getResultItem(null)}));
    }
}

