/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.items.dynamicfood;

import com.lance5057.extradelight.ExtraDelight;
import com.lance5057.extradelight.ExtraDelightComponents;
import com.lance5057.extradelight.items.dynamicfood.api.DynamicItemComponent;
import com.lance5057.extradelight.items.dynamicfood.api.IDynamic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;

public class DynamicJam
extends Item
implements IDynamic {
    public static final ResourceLocation base_model = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"extra/dynamics/jam/jam_jar");
    public static final ResourceLocation missing_model = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"extra/dynamics/jam/jam_missing");

    public DynamicJam(Item.Properties properties) {
        super(properties);
    }

    @Override
    public List<ResourceLocation> getPieces(ItemStack itemStack) {
        ArrayList<ResourceLocation> i = new ArrayList<ResourceLocation>();
        i.add(base_model);
        DynamicItemComponent comp = (DynamicItemComponent)itemStack.getComponents().get((DataComponentType)ExtraDelightComponents.DYNAMIC_FOOD.get());
        if (comp != null) {
            if (comp.graphics().size() > 0) {
                ResourceLocation rc = ExtraDelight.modLoc("extra/dynamics/jam/" + comp.graphics().get(0));
                i.add(rc);
            } else {
                i.add(missing_model);
            }
        } else {
            i.add(missing_model);
        }
        return i;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        ItemContainerContents comp = (ItemContainerContents)stack.getComponents().get((DataComponentType)ExtraDelightComponents.ITEMSTACK_HANDLER.get());
        if (comp != null) {
            if (isAdvanced.hasShiftDown()) {
                if (comp.nonEmptyItems() != null) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.dynamic.ingredients"));
                    for (ItemStack s : comp.nonEmptyItems()) {
                        tooltip.add((Component)Component.literal((String)" - ").append((Component)Component.translatable((String)s.getDescriptionId())));
                    }
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.see_more").withColor(-5592406));
            }
        }
    }

    public Component getName(ItemStack itemStack) {
        DynamicItemComponent dyn = (DynamicItemComponent)itemStack.getComponents().get((DataComponentType)ExtraDelightComponents.DYNAMIC_FOOD.get());
        if (dyn != null) {
            return Component.translatable((String)("extradelight.jam." + dyn.graphics().get(0)));
        }
        return Component.translatable((String)this.getDescriptionId());
    }
}

