/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.items.dynamicfood;

import com.lance5057.extradelight.ExtraDelight;
import com.lance5057.extradelight.ExtraDelightComponents;
import com.lance5057.extradelight.ExtraDelightTags;
import com.lance5057.extradelight.items.dynamicfood.api.DynamicItemComponent;
import com.lance5057.extradelight.items.dynamicfood.api.IDynamic;
import com.mojang.brigadier.Message;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;

public class DynamicToast
extends Item
implements IDynamic {
    static final ResourceLocation base_model = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"extra/dynamics/toast/toast");
    static final ResourceLocation missing_model = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"extra/dynamics/toast/empty_toast");

    public DynamicToast(Item.Properties properties) {
        super(properties);
    }

    @Override
    public List<ResourceLocation> getPieces(ItemStack itemStack) {
        ArrayList<ResourceLocation> i = new ArrayList<ResourceLocation>();
        i.add(base_model);
        DynamicItemComponent comp = (DynamicItemComponent)itemStack.getComponents().get((DataComponentType)ExtraDelightComponents.DYNAMIC_FOOD.get());
        ItemContainerContents items = (ItemContainerContents)itemStack.getComponents().get((DataComponentType)ExtraDelightComponents.ITEMSTACK_HANDLER.get());
        if (comp != null && items != null) {
            if (comp.graphics().size() > 0) {
                ResourceLocation rc = missing_model;
                String str = "extra/dynamics/toast/";
                for (ItemStack s : items.nonEmptyItems()) {
                    if (s.is(ExtraDelightTags.TOAST)) continue;
                    Item item = s.getItem();
                    if (item instanceof IDynamic) {
                        IDynamic id = (IDynamic)item;
                        DynamicItemComponent dyn = (DynamicItemComponent)s.get((DataComponentType)ExtraDelightComponents.DYNAMIC_FOOD.get());
                        rc = ExtraDelight.modLoc(str + "dynamic_jam/" + dyn.graphics().get(0));
                    } else {
                        rc = ExtraDelight.modLoc(str + comp.graphics().get(0));
                    }
                    i.add(rc);
                }
            } else {
                i.add(missing_model);
            }
        } else {
            i.add(missing_model);
        }
        return i;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        ItemContainerContents comp = (ItemContainerContents)stack.getComponents().get((DataComponentType)ExtraDelightComponents.ITEMSTACK_HANDLER.get());
        if (comp != null && comp.nonEmptyItems() != null) {
            tooltip.add((Component)Component.translatable((String)"tooltip.dynamic.ingredients"));
            for (ItemStack s : comp.nonEmptyItems()) {
                tooltip.add((Component)Component.literal((String)" - ").append(s.getItem().getName(s)));
                if (!isAdvanced.hasShiftDown()) continue;
                s.getItem().appendHoverText(stack, context, tooltip, isAdvanced);
            }
            if (!isAdvanced.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.see_more").withColor(-11184811));
            }
        }
    }

    public Component getName(ItemStack itemStack) {
        ItemContainerContents comp = (ItemContainerContents)itemStack.getComponents().get((DataComponentType)ExtraDelightComponents.ITEMSTACK_HANDLER.get());
        if (comp != null && comp.getSlots() > 1) {
            for (ItemStack stack : comp.nonEmptyItems()) {
                if (stack.is(ExtraDelightTags.TOAST)) continue;
                return Component.translationArg((Message)Component.translatable((String)this.getDescriptionId(itemStack), (Object[])new Object[]{stack.getItem().getName(stack)}));
            }
        }
        return Component.translatable((String)"dynamic.toast");
    }
}

