/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.items.dynamicfood.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicFoodChildBakedGeometry
implements BakedModel {
    private final List<BakedModel> childrenModels;

    public DynamicFoodChildBakedGeometry(List<BakedModel> childrenModels) {
        this.childrenModels = childrenModels;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
        for (BakedModel bakedModel : this.childrenModels) {
            bakedQuads.addAll(bakedModel.getQuads(state, side, rand));
        }
        return bakedQuads;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
        for (BakedModel bakedModel : this.childrenModels) {
            bakedQuads.addAll(bakedModel.getQuads(state, side, rand, data, renderType));
        }
        return bakedQuads;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        HashSet<ChunkRenderTypeSet> chunkRenderTypeSets = new HashSet<ChunkRenderTypeSet>();
        for (BakedModel bakedModel : this.childrenModels) {
            chunkRenderTypeSets.add(bakedModel.getRenderTypes(state, rand, data));
        }
        return ChunkRenderTypeSet.union(chunkRenderTypeSets);
    }

    public boolean useAmbientOcclusion() {
        return this.childrenModels.stream().anyMatch(BakedModel::useAmbientOcclusion);
    }

    public boolean isGui3d() {
        return this.childrenModels.stream().anyMatch(BakedModel::isGui3d);
    }

    public boolean usesBlockLight() {
        return this.childrenModels.stream().anyMatch(BakedModel::usesBlockLight);
    }

    public boolean isCustomRenderer() {
        return this.childrenModels.stream().anyMatch(BakedModel::isCustomRenderer);
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        if (this.childrenModels.isEmpty()) {
            return ModelBakery.FIRE_0.sprite();
        }
        return this.childrenModels.get(0).getParticleIcon();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData modelData) {
        if (this.childrenModels.isEmpty()) {
            return ModelBakery.FIRE_0.sprite();
        }
        return this.childrenModels.get(0).getParticleIcon(modelData);
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return new ItemOverrides(this){};
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        this.childrenModels.get(0).getTransforms().getTransform(transformType).apply(applyLeftHandTransform, poseStack);
        return this;
    }
}

