/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.items.dynamicfood.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.lance5057.extradelight.ExtraDelight;
import com.lance5057.extradelight.items.dynamicfood.DynamicJam;
import com.lance5057.extradelight.items.dynamicfood.api.IDynamic;
import com.lance5057.extradelight.items.dynamicfood.client.DynamicFoodChildBakedGeometry;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DynamicFoodItemOverrides
extends ItemOverrides {
    private final Cache<Integer, DynamicFoodChildBakedGeometry> cache = CacheBuilder.newBuilder().expireAfterWrite(Duration.of(5L, ChronoUnit.MINUTES)).build();

    @Nullable
    @ParametersAreNonnullByDefault
    public BakedModel resolve(BakedModel pModel, ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity pEntity, int pSeed) {
        Item item = pStack.getItem();
        if (item instanceof IDynamic) {
            IDynamic customizable = (IDynamic)item;
            List<ResourceLocation> resources = customizable.getPieces(pStack);
            ArrayList<BakedModel> pieces = new ArrayList<BakedModel>();
            for (ResourceLocation rc : resources) {
                BakedModel bm = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)rc));
                if (bm == Minecraft.getInstance().getModelManager().getMissingModel()) {
                    bm = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)DynamicJam.missing_model));
                }
                pieces.add(bm);
            }
            try {
                return (BakedModel)this.cache.get((Object)pieces.size(), () -> {
                    ArrayList<BakedModel> pieceBakedModels = new ArrayList<BakedModel>(pieces.size());
                    for (BakedModel iPiece : pieces) {
                        pieceBakedModels.add(iPiece);
                    }
                    return new DynamicFoodChildBakedGeometry(pieceBakedModels);
                });
            }
            catch (ExecutionException e) {
                ExtraDelight.logger.error("FAILED TO CREATE GEOMETRY FOR MODEL", (Throwable)e);
            }
        }
        return pModel;
    }
}

