/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.recipe;

import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.recipe.SimpleRecipeWrapper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class BottleFluidRegistryRecipe
implements Recipe<SimpleRecipeWrapper> {
    final String group;
    public Ingredient bottle;
    public SizedFluidIngredient fluid;

    public Ingredient getBottle() {
        return this.bottle;
    }

    public SizedFluidIngredient getFluid() {
        return this.fluid;
    }

    public BottleFluidRegistryRecipe(String group, Ingredient b, SizedFluidIngredient f) {
        this.group = group;
        this.fluid = f;
        this.bottle = b;
    }

    public boolean matches(SimpleRecipeWrapper input, Level level) {
        return false;
    }

    public ItemStack assemble(SimpleRecipeWrapper input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.BOTTLE_FLUID_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ExtraDelightRecipes.BOTTLE_FLUID_REGISTRY.get();
    }

    public static class Serializer
    implements RecipeSerializer<BottleFluidRegistryRecipe> {
        private static final MapCodec<BottleFluidRegistryRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)Ingredient.CODEC.fieldOf("bottle").forGetter(BottleFluidRegistryRecipe::getBottle), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid").forGetter(BottleFluidRegistryRecipe::getFluid)).apply((Applicative)inst, BottleFluidRegistryRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BottleFluidRegistryRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static BottleFluidRegistryRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            String s = pBuffer.readUtf();
            SizedFluidIngredient fluid = (SizedFluidIngredient)SizedFluidIngredient.STREAM_CODEC.decode((Object)pBuffer);
            Ingredient i = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            return new BottleFluidRegistryRecipe(s, i, fluid);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, BottleFluidRegistryRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.group);
            SizedFluidIngredient.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.fluid);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.bottle);
        }

        public MapCodec<BottleFluidRegistryRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BottleFluidRegistryRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

