/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.recipe;

import com.lance5057.extradelight.ExtraDelight;
import com.lance5057.extradelight.ExtraDelightComponents;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.items.dynamicfood.DynamicJam;
import com.lance5057.extradelight.items.dynamicfood.api.DynamicItemComponent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;

public class DynamicJamRecipe
extends CookingPotRecipe {
    private final String graphic;

    public DynamicJamRecipe(String group, CookingPotRecipeBookTab tab, NonNullList<Ingredient> inputItems, ItemStack output, ItemStack container, float experience, int cookTime, String graphic) {
        super(group, tab, inputItems, output, container, experience, cookTime);
        this.graphic = graphic;
    }

    public String getGraphic() {
        return this.graphic;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        ItemStack stack = super.getResultItem(provider);
        Item item = stack.getItem();
        if (item instanceof DynamicJam) {
            DynamicJam jam = (DynamicJam)item;
            stack.set((DataComponentType)ExtraDelightComponents.DYNAMIC_FOOD.get(), (Object)new DynamicItemComponent(List.of(this.graphic)));
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (Ingredient i : this.getIngredients()) {
                if (i.getItems().length <= 0) continue;
                stacks.add(i.getItems()[0]);
            }
            stack.set((DataComponentType)ExtraDelightComponents.ITEMSTACK_HANDLER.get(), (Object)ItemContainerContents.fromItems(stacks));
        } else {
            ExtraDelight.logger.error("DynamicJamRecipe result not DynamicJam!");
        }
        return stack;
    }

    public ItemStack assemble(RecipeWrapper inv, HolderLookup.Provider provider) {
        ItemStack stack = this.getResultItem(provider).copy();
        if (stack.getItem() instanceof DynamicJam) {
            int nutrition = 0;
            float saturation = 0.0f;
            ArrayList effects = new ArrayList();
            ArrayList<ItemStack> l = new ArrayList<ItemStack>();
            for (int i = 0; i < inv.size() - 2; ++i) {
                ItemStack s = inv.getItem(i);
                if (s == null || s.isEmpty()) continue;
                l.add(s);
                if (!s.has(DataComponents.FOOD)) continue;
                FoodProperties f = (FoodProperties)s.get(DataComponents.FOOD);
                nutrition += f.nutrition();
                saturation += f.saturation();
                effects.addAll(f.effects());
            }
            FoodProperties food = new FoodProperties(nutrition, saturation / (float)inv.size(), false, 1.6f, Optional.empty(), effects);
            stack.set(DataComponents.FOOD, (Object)food);
        } else {
            ExtraDelight.logger.error("DynamicToastRecipe result not DynamicToast!");
        }
        return stack;
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.DYNAMIC_JAM_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<DynamicJamRecipe> {
        private static final MapCodec<DynamicJamRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(CookingPotRecipe::getGroup), (App)CookingPotRecipeBookTab.CODEC.optionalFieldOf("recipe_book_tab").xmap(optional -> optional.orElse(null), Optional::of).forGetter(CookingPotRecipe::getRecipeBookTab), (App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredients").xmap(ingredients -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)ingredients);
            return nonNullList;
        }, ingredients -> ingredients).forGetter(CookingPotRecipe::getIngredients), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.getResultItem(null)), (App)ItemStack.STRICT_CODEC.optionalFieldOf("container", (Object)ItemStack.EMPTY).forGetter(CookingPotRecipe::getContainerOverride), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(CookingPotRecipe::getExperience), (App)Codec.INT.optionalFieldOf("cookingtime", (Object)200).forGetter(CookingPotRecipe::getCookTime), (App)Codec.STRING.optionalFieldOf("graphic", (Object)"").forGetter(DynamicJamRecipe::getGraphic)).apply((Applicative)inst, DynamicJamRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DynamicJamRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<DynamicJamRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DynamicJamRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static DynamicJamRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String groupIn = buffer.readUtf();
            CookingPotRecipeBookTab tabIn = CookingPotRecipeBookTab.findByName((String)buffer.readUtf());
            int i = buffer.readVarInt();
            NonNullList inputItemsIn = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            inputItemsIn.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack outputIn = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            ItemStack container = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            float experienceIn = buffer.readFloat();
            int cookTimeIn = buffer.readVarInt();
            String graphic = buffer.readUtf();
            return new DynamicJamRecipe(groupIn, tabIn, (NonNullList<Ingredient>)inputItemsIn, outputIn, container, experienceIn, cookTimeIn, graphic);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, DynamicJamRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeUtf(recipe.getRecipeBookTab() != null ? recipe.getRecipeBookTab().toString() : "");
            buffer.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ingredient : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getResultItem(null));
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.getOutputContainer());
            buffer.writeFloat(recipe.getExperience());
            buffer.writeVarInt(recipe.getCookTime());
            buffer.writeUtf(recipe.getGraphic());
        }
    }
}

