/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.recipe;

import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.recipe.SimpleRecipeWrapper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ToolOnBlockRecipe
implements Recipe<SimpleRecipeWrapper> {
    protected final Ingredient tool;
    protected final BlockItem in;
    protected final BlockItem out;

    public Ingredient getTool() {
        return this.tool;
    }

    public BlockItem getIn() {
        return this.in;
    }

    public BlockItem getOut() {
        return this.out;
    }

    public ToolOnBlockRecipe(BlockItem in, Ingredient tool, BlockItem out) {
        this.tool = tool;
        this.in = in;
        this.out = out;
    }

    public ToolOnBlockRecipe(ItemStack in, Ingredient tool, ItemStack out) {
        this.tool = tool;
        this.in = (BlockItem)in.getItem();
        this.out = (BlockItem)out.getItem();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public Block getResultBlock() {
        return this.out.getBlock();
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.TOOL_ON_BLOCK_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ExtraDelightRecipes.TOOL_ON_BLOCK.get();
    }

    public boolean matches(SimpleRecipeWrapper input, Level level) {
        if (this.tool.test(input.getItem(0))) {
            return this.in == input.getItem(1).getItem();
        }
        return false;
    }

    public ItemStack assemble(SimpleRecipeWrapper input, HolderLookup.Provider registries) {
        return new ItemStack((ItemLike)this.out);
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return new ItemStack((ItemLike)this.out);
    }

    public static class Serializer
    implements RecipeSerializer<ToolOnBlockRecipe> {
        private static final MapCodec<ToolOnBlockRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("in").forGetter(r -> new ItemStack((ItemLike)r.in)), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(p_301068_ -> p_301068_.tool), (App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("out").forGetter(r -> new ItemStack((ItemLike)r.out))).apply((Applicative)inst, ToolOnBlockRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ToolOnBlockRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static ToolOnBlockRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            BlockItem bIn = (BlockItem)((ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer)).getItem();
            BlockItem bOut = (BlockItem)((ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer)).getItem();
            return new ToolOnBlockRecipe(bIn, ingredient, bOut);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, ToolOnBlockRecipe pRecipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.tool);
            ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)new ItemStack((ItemLike)pRecipe.in));
            ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)new ItemStack((ItemLike)pRecipe.out));
        }

        public MapCodec<ToolOnBlockRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ToolOnBlockRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

