/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.util;

import org.apache.commons.lang3.ArrayUtils;

public class MathUtil {
    public static float[] blockAngles = new float[]{0.0f, 22.5f, 45.0f, 67.5f, 90.0f, 112.5f, 135.0f, 157.5f, 180.0f, 202.5f, 225.0f, 247.5f, 270.0f, 292.5f, 315.0f, 337.5f};

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static float search(float value) {
        if (value < blockAngles[0]) {
            return blockAngles[0];
        }
        if (value > blockAngles[blockAngles.length - 1]) {
            return blockAngles[blockAngles.length - 1];
        }
        int lo = 0;
        int hi = blockAngles.length - 1;
        while (lo <= hi) {
            int mid = (hi + lo) / 2;
            if (value < blockAngles[mid]) {
                hi = mid - 1;
                continue;
            }
            if (value > blockAngles[mid]) {
                lo = mid + 1;
                continue;
            }
            return blockAngles[mid];
        }
        return blockAngles[lo] - value < value - blockAngles[hi] ? blockAngles[lo] : blockAngles[hi];
    }

    public static int getAngleIndex(float value) {
        return ArrayUtils.indexOf((float[])blockAngles, (float)value);
    }

    public static float lerp(float a, float b, float t) {
        return a * (1.0f - t) + b * t;
    }
}

