/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations;

import com.lance5057.extradelight.util.BlockEntityUtils;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.FancyTank;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public interface IFancyTankHandler<T extends BlockEntity> {
    public FancyTank getFluidTank();

    public IItemHandlerModifiable getItemHandler();

    public void updateInventory();

    public int getFluidInSlot();

    public int getFluidOutSlot();

    default public void fillInternal(T be) {
        ItemStack inputItem = this.getItemHandler().getStackInSlot(this.getFluidInSlot());
        if (!inputItem.isEmpty()) {
            Item item = inputItem.getItem();
            if (item instanceof BucketItem) {
                BucketItem filledBucket = (BucketItem)item;
                int filled = this.getFluidTank().fill(new FluidStack(filledBucket.content, 1000), IFluidHandler.FluidAction.SIMULATE);
                if (filled == 1000) {
                    this.getFluidTank().fill(new FluidStack(filledBucket.content, 1000), IFluidHandler.FluidAction.EXECUTE);
                    BlockEntityUtils.Inventory.dropItemInWorld(Items.BUCKET.getDefaultInstance().copy(), be.getLevel(), be.getBlockPos());
                    this.getItemHandler().getStackInSlot(this.getFluidInSlot()).shrink(1);
                    this.updateInventory();
                }
            } else if (inputItem.getCapability(Capabilities.FluidHandler.ITEM) != null) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)inputItem.getCapability(Capabilities.FluidHandler.ITEM);
                int filled = FluidUtil.tryFluidTransfer((IFluidHandler)this.getFluidTank(), (IFluidHandler)fluidHandlerItem, (int)this.getFluidTank().getVacancy(), (boolean)true).getAmount();
                if (filled > 0) {
                    BlockEntityUtils.Inventory.dropItemInWorld(fluidHandlerItem.getContainer().copy(), be.getLevel(), be.getBlockPos());
                    this.getItemHandler().getStackInSlot(this.getFluidInSlot()).shrink(1);
                    this.updateInventory();
                }
            } else {
                FluidStack f = BottleFluidRegistry.getFluidFromBottle(inputItem);
                if (!f.isEmpty() && this.getFluidTank().fill(f, IFluidHandler.FluidAction.SIMULATE) == 250) {
                    int sz = inputItem.getCount();
                    for (int j = 0; j < sz; ++j) {
                        this.getFluidTank().fill(f.copy(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    if (inputItem.is(Items.POTION)) {
                        BlockEntityUtils.Inventory.dropItemInWorld(Items.GLASS_BOTTLE.getDefaultInstance(), be.getLevel(), be.getBlockPos());
                    } else {
                        BlockEntityUtils.Inventory.dropItemInWorld(inputItem.getCraftingRemainingItem().copyWithCount(sz), be.getLevel(), be.getBlockPos());
                    }
                    this.getItemHandler().getStackInSlot(this.getFluidInSlot()).shrink(sz);
                    this.updateInventory();
                }
            }
        }
    }

    default public void drainInternal(T be) {
        ItemStack inputItem = this.getItemHandler().getStackInSlot(this.getFluidOutSlot());
        if (!inputItem.isEmpty()) {
            int sz = inputItem.getCount();
            if (inputItem.getItem() == Items.BUCKET) {
                int oitr;
                FluidStack stack = this.getFluidTank().drain(1000, IFluidHandler.FluidAction.SIMULATE);
                ItemStack item = stack.getFluid().getBucket().getDefaultInstance();
                int itr = oitr = Math.min(sz, this.getFluidTank().getFluidAmount(0) / 1000);
                while (stack.getAmount() == 1000 && itr-- >= 0) {
                    this.getFluidTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    BlockEntityUtils.Inventory.dropItemInWorld(item.copy(), be.getLevel(), be.getBlockPos());
                    inputItem.shrink(1);
                    stack = this.getFluidTank().drain(1000, IFluidHandler.FluidAction.SIMULATE);
                }
                this.updateInventory();
            } else if (inputItem.getCapability(Capabilities.FluidHandler.ITEM) != null) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)inputItem.copyWithCount(1).getCapability(Capabilities.FluidHandler.ITEM);
                int maxFill = Math.min(this.getFluidTank().getFluidAmount(0), (fluidHandlerItem.getTankCapacity(0) - fluidHandlerItem.getFluidInTank(0).getAmount()) * sz);
                int filled = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandlerItem, (IFluidHandler)this.getFluidTank(), (int)maxFill, (boolean)true).getAmount();
                maxFill -= filled;
                while (filled > 0 && maxFill >= 0) {
                    filled = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandlerItem, (IFluidHandler)this.getFluidTank(), (int)maxFill, (boolean)true).getAmount();
                    BlockEntityUtils.Inventory.dropItemInWorld(fluidHandlerItem.getContainer().copy(), be.getLevel(), be.getBlockPos());
                    inputItem.shrink(1);
                }
                this.updateInventory();
            } else if (this.getFluidTank().getFluid() != null) {
                FluidStack stack = this.getFluidTank().drain(250, IFluidHandler.FluidAction.SIMULATE);
                ItemStack i = BottleFluidRegistry.getBottleFromFluid(stack);
                if (!i.isEmpty() && ItemStack.isSameItem((ItemStack)i.getCraftingRemainingItem(), (ItemStack)inputItem)) {
                    for (int j = 0; j < sz; ++j) {
                        this.getFluidTank().drain(stack, IFluidHandler.FluidAction.EXECUTE);
                    }
                    BlockEntityUtils.Inventory.dropItemInWorld(i.copyWithCount(sz), be.getLevel(), be.getBlockPos());
                }
                if (i.getItem() == Items.POTION && inputItem.getItem() == Items.GLASS_BOTTLE) {
                    FluidStack stack1 = this.getFluidTank().drain(250, IFluidHandler.FluidAction.SIMULATE);
                    for (int j = 0; j < sz; ++j) {
                        this.getFluidTank().drain(stack1, IFluidHandler.FluidAction.EXECUTE);
                        BlockEntityUtils.Inventory.dropItemInWorld(i, be.getLevel(), be.getBlockPos());
                    }
                }
                inputItem.shrink(sz);
                this.updateInventory();
            }
        }
    }
}

