/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.dryingrack;

import com.lance5057.extradelight.ExtraDelightRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class DryingRackRecipe
implements Recipe<SingleRecipeInput> {
    protected final String group;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final float experience;
    protected final int cookingTime;

    public DryingRackRecipe(String pGroup, Ingredient pIngredient, ItemStack pResult, float pExperience, int pCookingTime) {
        this.group = pGroup;
        this.ingredient = pIngredient;
        this.result = pResult;
        this.experience = pExperience;
        this.cookingTime = pCookingTime;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of(null, (Object[])new Ingredient[]{this.ingredient});
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.DRYING_RACK_SERIALIZER.get();
    }

    public boolean matches(SingleRecipeInput pContainer, Level pLevel) {
        return this.ingredient.test(pContainer.getItem(0));
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public Ingredient getInput() {
        return this.ingredient;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public RecipeType<?> getType() {
        return ExtraDelightRecipes.DRYING_RACK.get();
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public String getGroup() {
        return this.group;
    }
}

