/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.dryingrack;

import com.lance5057.extradelight.workstations.dryingrack.DryingRackBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.joml.Quaternionf;

public class DryingRackRenderer
implements BlockEntityRenderer<DryingRackBlockEntity> {
    public DryingRackRenderer(BlockEntityRendererProvider.Context cxt) {
    }

    public void render(DryingRackBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        IItemHandlerModifiable inv = pBlockEntity.getItemHandler();
        for (int i = 0; i < 8; ++i) {
            ItemStack item = inv.getStackInSlot(i);
            if (item.isEmpty()) continue;
            BakedModel bakedmodel = itemRenderer.getModel(item, pBlockEntity.getLevel(), null, 0);
            pPoseStack.pushPose();
            pPoseStack.translate(0.5f, 0.45f + (i > 3 ? 0.5f : 0.0f), 0.5f);
            pPoseStack.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(135.0), 0.0f));
            pPoseStack.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(90 * (i % 4)), 0.0f));
            pPoseStack.mulPose(new Quaternionf().rotateXYZ((float)Math.toRadians(90.0), 0.0f, 0.0f));
            pPoseStack.translate(0.25f, 0.0f, 0.0f);
            float uniscale = 0.65f;
            pPoseStack.scale(uniscale, uniscale, uniscale);
            itemRenderer.render(item, ItemDisplayContext.GROUND, false, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, bakedmodel);
            pPoseStack.popPose();
        }
    }
}

