/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.evaporator;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.blocks.interfaces.IStyleable;
import com.lance5057.extradelight.workstations.evaporator.EvaporatorBlockEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class EvaporatorBlock
extends Block
implements EntityBlock,
IStyleable {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final IntegerProperty STYLE = IntegerProperty.create((String)"style", (int)0, (int)(Styles.values().length - 1));

    public EvaporatorBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STYLE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_53681_) {
        p_53681_.add(new Property[]{STYLE});
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = pLevel.getBlockEntity(pPos);
        if (tileEntity instanceof EvaporatorBlockEntity) {
            EvaporatorBlockEntity mbe = (EvaporatorBlockEntity)tileEntity;
            if (mbe.isInventoryEmpty()) {
                IFluidHandlerItem f = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
                if (f != null) {
                    FluidUtil.interactWithFluidHandler((Player)pPlayer, (InteractionHand)pHand, (IFluidHandler)mbe.getFluidTank());
                }
            } else if (stack.is(ItemTags.SHOVELS)) {
                mbe.dropItems();
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new EvaporatorBlockEntity(pPos, pState);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof EvaporatorBlockEntity) {
                EvaporatorBlockEntity te = (EvaporatorBlockEntity)tileEntity;
                IItemHandlerModifiable items = te.getItemHandler();
                for (int i = 0; i < te.getItemHandler().getSlots(); ++i) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), items.getStackInSlot(i)));
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Override
    public int numStyles() {
        return Styles.values().length;
    }

    @Override
    public int getCurrentStyle(BlockState state) {
        return (Integer)state.getValue((Property)STYLE);
    }

    @Override
    public void setNextStyle(Level level, BlockPos pos, BlockState state) {
        int next = (Integer)state.getValue((Property)STYLE) + 1;
        if ((Integer)state.getValue((Property)STYLE) >= this.numStyles() - 1) {
            next = 0;
        }
        for (int i = 0; i < 10; ++i) {
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW_BLOCK.defaultBlockState()), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
        }
        level.playSound(null, pos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        BlockState nextState = (BlockState)state.setValue((Property)STYLE, (Comparable)Integer.valueOf(next));
        level.setBlock(pos, nextState, 3);
    }

    @Override
    public void setPrevStyle(Level level, BlockPos pos, BlockState state) {
        int next = (Integer)state.getValue((Property)STYLE) - 1;
        if (next < 0) {
            next = this.numStyles() - 1;
        }
        for (int i = 0; i < 10; ++i) {
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW_BLOCK.defaultBlockState()), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
        }
        level.playSound(null, pos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        BlockState nextState = (BlockState)state.setValue((Property)STYLE, (Comparable)Integer.valueOf(next));
        level.setBlock(pos, nextState, 3);
    }

    @Override
    public BlockState getState(int i) {
        return (BlockState)this.defaultBlockState().setValue((Property)STYLE, (Comparable)Integer.valueOf(i));
    }

    @Override
    public void setStyle(Level level, BlockPos pos, BlockState state, int style) {
        BlockState nextState = (BlockState)state.setValue((Property)STYLE, (Comparable)Integer.valueOf(style));
        level.setBlock(pos, nextState, 3);
    }

    @Override
    public boolean isPatreonStyle(int style) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        MutableComponent textEmpty = Component.translatable((String)"extradelight.tooltip.styleable");
        tooltipComponents.add((Component)textEmpty.withStyle(ChatFormatting.AQUA));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (!pLevel.isClientSide()) {
            return pBlockEntityType == ExtraDelightBlockEntities.EVAPORATOR.get() ? EvaporatorBlockEntity::tick : null;
        }
        return null;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)STYLE, (Comparable)((Integer)state.getValue((Property)STYLE))));
        return stack;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && !player.isCreative() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            ItemStack itemstack = new ItemStack((ItemLike)this);
            itemstack.set(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)STYLE, (Comparable)((Integer)state.getValue((Property)STYLE))));
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public static enum Styles {
        ANVIL,
        GOLD_BLOCK,
        NETHERITE_BLOCK,
        COPPER_BLOCK,
        IRON_BLOCK;

    }
}

