/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.evaporator;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.util.BlockEntityUtils;
import com.lance5057.extradelight.workstations.evaporator.recipes.EvaporatorRecipe;
import com.lance5057.extradelight.workstations.evaporator.recipes.EvaporatorRecipeWrapper;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;

public class EvaporatorBlockEntity
extends SyncedBlockEntity
implements RecipeCraftingHolder {
    public static ResourceLocation ice = BuiltInRegistries.BLOCK.getKey((Object)Blocks.ICE);
    public static ResourceLocation air = BuiltInRegistries.BLOCK.getKey((Object)Blocks.AIR);
    public static final String INV_TAG = "inv";
    private final ItemStackHandler items = this.createHandler();
    private final Lazy<IItemHandlerModifiable> itemHandler = Lazy.of(() -> this.items);
    public static final int NUM_SLOTS = 9;
    public static final String FLUID_TAG = "fluid";
    private final FluidTank tank = this.createFluidHandler();
    private int cookTime = 0;
    private int cookTimeTotal = 0;
    private ResourceLocation displayBlock = BuiltInRegistries.BLOCK.getKey((Object)Blocks.AIR);
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe;
    private final RecipeManager.CachedCheck<EvaporatorRecipeWrapper, EvaporatorRecipe> quickCheck = RecipeManager.createCheck(ExtraDelightRecipes.EVAPORATOR.get());

    public ResourceLocation getDisplayBlock() {
        return this.displayBlock;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    private FluidTank createFluidHandler() {
        FluidTank tank = new FluidTank(1000){

            protected void onContentsChanged() {
                EvaporatorBlockEntity.this.requestModelDataUpdate();
                EvaporatorBlockEntity.this.getLevel().sendBlockUpdated(EvaporatorBlockEntity.this.getBlockPos(), EvaporatorBlockEntity.this.getBlockState(), EvaporatorBlockEntity.this.getBlockState(), 3);
                EvaporatorBlockEntity.this.setChanged();
                EvaporatorBlockEntity.this.zeroProgress();
                EvaporatorBlockEntity.this.updateInventory();
            }
        };
        return tank;
    }

    public EvaporatorBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ExtraDelightBlockEntities.EVAPORATOR.get(), pPos, pState);
    }

    public float getFullness() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.itemHandler.get();
    }

    public FluidTank getFluidTank() {
        return this.tank;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                EvaporatorBlockEntity.this.requestModelDataUpdate();
                EvaporatorBlockEntity.this.getLevel().sendBlockUpdated(EvaporatorBlockEntity.this.getBlockPos(), EvaporatorBlockEntity.this.getBlockState(), EvaporatorBlockEntity.this.getBlockState(), 3);
                EvaporatorBlockEntity.this.setChanged();
                EvaporatorBlockEntity.this.zeroProgress();
                EvaporatorBlockEntity.this.updateInventory();
            }
        };
    }

    public void insertItem(ItemStack stack) {
        BlockEntityUtils.Inventory.insertItem((IItemHandler)this.items, stack, 9);
        this.updateInventory();
    }

    public boolean isInventoryEmpty() {
        boolean flag = true;
        for (int i = 0; i < this.items.getSlots(); ++i) {
            if (this.items.getStackInSlot(i).isEmpty()) continue;
            flag = false;
        }
        return flag;
    }

    public void zeroProgress() {
        this.cookTimeTotal = 0;
        this.cookTime = 0;
    }

    public void updateInventory() {
        this.requestModelDataUpdate();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    public ItemStack getInsertedItem() {
        return this.items.getStackInSlot(0);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains(INV_TAG)) {
            this.items.deserializeNBT(registries, nbt.getCompound(INV_TAG));
        }
        this.tank.readFromNBT(registries, nbt);
        this.cookTime = nbt.getInt("cookTime");
        this.cookTimeTotal = nbt.getInt("cookTimeTotal");
        this.displayBlock = ResourceLocation.parse((String)nbt.getString("display"));
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(INV_TAG, (Tag)this.items.serializeNBT(registries));
        this.tank.writeToNBT(registries, tag);
        tag.putInt("cookTime", this.cookTime);
        tag.putInt("cookTimeTotal", this.cookTimeTotal);
        tag.putString("display", this.displayBlock.toString());
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }

    public Optional<RecipeHolder<EvaporatorRecipe>> matchRecipe() {
        if (this.level != null) {
            return this.level.getRecipeManager().getRecipeFor(ExtraDelightRecipes.EVAPORATOR.get(), (RecipeInput)new EvaporatorRecipeWrapper(this.tank), this.level);
        }
        return Optional.empty();
    }

    public void setRecipeUsed(RecipeHolder<?> p_300902_) {
    }

    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        EvaporatorBlockEntity evaporator = (EvaporatorBlockEntity)be;
        float temp = ((Biome)level.getBiome(pos).value()).getBaseTemperature();
        if ((double)temp > 0.05) {
            RecipeHolder recipeholder;
            if (level.random.nextFloat() <= temp && (recipeholder = (RecipeHolder)evaporator.quickCheck.getRecipeFor((RecipeInput)new EvaporatorRecipeWrapper(evaporator.tank), level).orElse(null)) != null) {
                evaporator.cookTimeTotal = ((EvaporatorRecipe)recipeholder.value()).getCookTime();
                evaporator.displayBlock = ((EvaporatorRecipe)recipeholder.value()).getDisplay();
                if (evaporator.cookTime >= evaporator.cookTimeTotal) {
                    EvaporatorBlockEntity.dropLoot(evaporator, ((EvaporatorRecipe)recipeholder.value()).getOutput());
                    SizedFluidIngredient sfi = ((EvaporatorRecipe)recipeholder.value()).getFluid();
                    evaporator.tank.drain(sfi.amount(), IFluidHandler.FluidAction.EXECUTE);
                } else {
                    ++evaporator.cookTime;
                }
            }
        } else {
            evaporator.displayBlock = ice;
        }
    }

    private static void dropLoot(EvaporatorBlockEntity evaporator, ResourceLocation rc) {
        if (evaporator.level != null && !evaporator.level.isClientSide()) {
            LootParams pParams = new LootParams.Builder((ServerLevel)evaporator.level).withParameter(LootContextParams.ORIGIN, (Object)evaporator.worldPosition.getCenter()).create(LootContextParamSets.ARCHAEOLOGY);
            evaporator.level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)rc)).getRandomItems(pParams).forEach(itemStack -> evaporator.insertItem(itemStack.copy()));
        }
    }

    public void dropItems() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.5f), (double)((float)this.worldPosition.getZ() + 0.5f), stack.copy()));
            this.items.setStackInSlot(i, ItemStack.EMPTY);
        }
    }
}

