/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.evaporator;

import com.lance5057.extradelight.util.RenderUtil;
import com.lance5057.extradelight.workstations.evaporator.EvaporatorBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class EvaporatorRenderer
implements BlockEntityRenderer<EvaporatorBlockEntity> {
    public EvaporatorRenderer(BlockEntityRendererProvider.Context cxt) {
    }

    public void render(EvaporatorBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        IItemHandlerModifiable inv = pBlockEntity.getItemHandler();
        ItemStack item = inv.getStackInSlot(0);
        if (!item.isEmpty() || pBlockEntity.getDisplayBlock() == EvaporatorBlockEntity.ice) {
            ResourceLocation display = pBlockEntity.getDisplayBlock();
            BlockRenderDispatcher br = Minecraft.getInstance().getBlockRenderer();
            pPoseStack.pushPose();
            pPoseStack.translate(0.05f, 0.11f, 0.05f);
            pPoseStack.scale(0.9f, 0.1f, 0.9f);
            br.renderSingleBlock(((Block)BuiltInRegistries.BLOCK.get(display)).defaultBlockState(), pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, ModelData.EMPTY, null);
            pPoseStack.popPose();
        }
        if (!pBlockEntity.getFluidTank().getFluid().isEmpty()) {
            VertexConsumer vertexConsumer = pBufferSource.getBuffer(Sheets.translucentCullBlockSheet());
            Matrix4f mat = pPoseStack.last().pose();
            Matrix3f matrix3f = pPoseStack.last().normal();
            pPoseStack.pushPose();
            FluidStack fluidStack = pBlockEntity.getFluidTank().getFluid();
            Fluid fluid = fluidStack.getFluid();
            IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
            RenderUtil.buildPlane(new Vector3f(0.0f, 0.2f, 0.0f), new Vector3f(0.0f, 0.2f, 1.0f), new Vector3f(1.0f, 0.2f, 1.0f), new Vector3f(1.0f, 0.2f, 0.0f), vertexConsumer, mat, matrix3f, fluidTypeExtensions.getTintColor(fluidStack), RenderUtil.getUV(fluidTypeExtensions.getStillTexture()), Direction.UP.getNormal(), pPackedLight, pPackedOverlay, pPoseStack);
            pPoseStack.popPose();
        }
    }
}

