/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.evaporator.recipes;

import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.workstations.evaporator.recipes.EvaporatorRecipeWrapper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class EvaporatorRecipe
implements Recipe<EvaporatorRecipeWrapper> {
    final String group;
    protected final int cookTime;
    final SizedFluidIngredient fluid;
    final ResourceLocation output;
    final ResourceLocation display;
    final ItemStack outItem;

    public int getCookTime() {
        return this.cookTime;
    }

    public ResourceLocation getOutput() {
        return this.output;
    }

    public SizedFluidIngredient getFluid() {
        return this.fluid;
    }

    public ResourceLocation getDisplay() {
        return this.display;
    }

    public EvaporatorRecipe(String pGroup, SizedFluidIngredient fluid, int time, ResourceLocation lootTable, ResourceLocation displayBlock, ItemStack outItem) {
        this.group = pGroup;
        this.cookTime = time;
        this.fluid = fluid;
        this.output = lootTable;
        this.display = displayBlock;
        this.outItem = outItem;
    }

    public boolean matches(EvaporatorRecipeWrapper input, Level level) {
        return this.fluid.test(input.tank.getFluid());
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ExtraDelightBlocks.EVAPORATOR.get());
    }

    public ItemStack assemble(EvaporatorRecipeWrapper input, HolderLookup.Provider registries) {
        return this.getResultItem(registries).copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.outItem;
    }

    public ItemStack getResultItem() {
        return this.outItem;
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.EVAPORATOR_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ExtraDelightRecipes.EVAPORATOR.get();
    }

    public String getGroup() {
        return this.group;
    }

    public static class Serializer
    implements RecipeSerializer<EvaporatorRecipe> {
        private static final MapCodec<EvaporatorRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(EvaporatorRecipe::getGroup), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid").forGetter(EvaporatorRecipe::getFluid), (App)Codec.INT.fieldOf("time").forGetter(EvaporatorRecipe::getCookTime), (App)ResourceLocation.CODEC.fieldOf("loottable").forGetter(EvaporatorRecipe::getOutput), (App)ResourceLocation.CODEC.fieldOf("display_block").forGetter(EvaporatorRecipe::getDisplay), (App)ItemStack.CODEC.fieldOf("outItem").forGetter(EvaporatorRecipe::getResultItem)).apply((Applicative)inst, EvaporatorRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EvaporatorRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static EvaporatorRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            String s = pBuffer.readUtf();
            SizedFluidIngredient fluid = (SizedFluidIngredient)SizedFluidIngredient.STREAM_CODEC.decode((Object)pBuffer);
            int g = pBuffer.readVarInt();
            ResourceLocation r = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)pBuffer);
            ResourceLocation d = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)pBuffer);
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer);
            return new EvaporatorRecipe(s, fluid, g, r, d, stack);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, EvaporatorRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.group);
            SizedFluidIngredient.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.fluid);
            pBuffer.writeVarInt(pRecipe.cookTime);
            ResourceLocation.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.output);
            ResourceLocation.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.display);
            ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.outItem);
        }

        public MapCodec<EvaporatorRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EvaporatorRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

