/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.juicer;

import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class JuicerRecipe
extends SingleItemRecipe {
    protected final FluidStack fluidOut;
    protected final int percentChance;

    public JuicerRecipe(String pGroup, Ingredient pIngredient, ItemStack pResult, int chance, FluidStack fluidResult) {
        super(ExtraDelightRecipes.JUICER.get(), ExtraDelightRecipes.JUICER_SERIALIZER.get(), pGroup, pIngredient, pResult);
        this.fluidOut = fluidResult;
        this.percentChance = chance;
    }

    public FluidStack getFluid() {
        return this.fluidOut;
    }

    public Ingredient getInput() {
        return this.ingredient;
    }

    public int getChance() {
        return this.percentChance;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.ingredient.test(input.getItem(0));
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ExtraDelightBlocks.JUICER.get());
    }

    public static class Serializer
    implements RecipeSerializer<JuicerRecipe> {
        private static final MapCodec<JuicerRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(SingleItemRecipe::getGroup), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(p_301068_ -> ((JuicerRecipe)p_301068_).ingredient), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(r -> ((JuicerRecipe)r).result), (App)Codec.INT.fieldOf("chance").forGetter(r -> r.percentChance), (App)FluidStack.OPTIONAL_CODEC.fieldOf("fluidOut").forGetter(JuicerRecipe::getFluid)).apply((Applicative)inst, JuicerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, JuicerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static JuicerRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            String s = pBuffer.readUtf();
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            ItemStack itemstack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
            int chance = pBuffer.readInt();
            FluidStack fluid = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
            return new JuicerRecipe(s, ingredient, itemstack, chance, fluid);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, JuicerRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.ingredient);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.result);
            pBuffer.writeInt(pRecipe.percentChance);
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.fluidOut);
        }

        public MapCodec<JuicerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, JuicerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

