/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.juicer;

import com.lance5057.extradelight.util.RenderUtil;
import com.lance5057.extradelight.workstations.juicer.JuicerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.renderable.BakedModelRenderable;
import net.neoforged.neoforge.client.model.renderable.IRenderable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class JuicerRenderer
implements BlockEntityRenderer<JuicerBlockEntity> {
    ModelResourceLocation crankRC = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"extra/juicer_crank"));
    IRenderable<ModelData> crank;
    ModelResourceLocation plateRC = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"extra/juicer_plate"));
    IRenderable<ModelData> plate;

    public JuicerRenderer(BlockEntityRendererProvider.Context cxt) {
        this.crank = BakedModelRenderable.of((ModelResourceLocation)this.crankRC).withModelDataContext();
        this.plate = BakedModelRenderable.of((ModelResourceLocation)this.plateRC).withModelDataContext();
    }

    public void render(JuicerBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Quaternionf q = ((Direction)pBlockEntity.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getRotation();
        float g = pBlockEntity.getGrind();
        float height = -0.075f * (g - 1.0f) + 0.1f;
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 0.0, 0.5);
        pPoseStack.translate(0.0f, 0.0f + height, 0.0f);
        pPoseStack.mulPose(new Quaternionf().rotateY(g));
        pPoseStack.translate(-0.5, 0.0, -0.5);
        this.crank.render(pPoseStack, pBufferSource, texture -> RenderType.entitySolid((ResourceLocation)texture), 0xF00000, pPackedOverlay, pPartialTick, (Object)ModelData.EMPTY);
        pPoseStack.popPose();
        pPoseStack.pushPose();
        pPoseStack.translate(0.0, 0.875 + (double)height, 0.0);
        this.plate.render(pPoseStack, pBufferSource, texture -> RenderType.entitySolid((ResourceLocation)texture), 0xF00000, pPackedOverlay, pPartialTick, (Object)ModelData.EMPTY);
        pPoseStack.popPose();
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        IItemHandlerModifiable inv = pBlockEntity.getItemHandler();
        ItemStack item = inv.getStackInSlot(0);
        if (!item.isEmpty()) {
            for (int i = 0; i < item.getCount(); ++i) {
                BakedModel bakedmodel = itemRenderer.getModel(item, pBlockEntity.getLevel(), null, 0);
                pPoseStack.pushPose();
                pPoseStack.translate(0.5f, 0.15f, 0.5f);
                pPoseStack.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians((float)(90 * i) + 45.0f * g), 0.0f));
                pPoseStack.mulPose(new Quaternionf().rotateXYZ((float)Math.toRadians(45.0), 0.0f, (float)Math.toRadians(45.0)));
                pPoseStack.translate(0.15f, 0.0f, 0.0f);
                float scale = 1.0f / (1.0f + g);
                pPoseStack.scale(scale, scale, scale);
                float uniscale = 0.65f;
                pPoseStack.scale(uniscale, uniscale, uniscale);
                itemRenderer.render(item, ItemDisplayContext.GROUND, false, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, bakedmodel);
                pPoseStack.popPose();
            }
        }
        if (!pBlockEntity.getFluidTank().getFluid().isEmpty()) {
            VertexConsumer vertexConsumer = pBufferSource.getBuffer(Sheets.translucentCullBlockSheet());
            Matrix4f mat = pPoseStack.last().pose();
            Matrix3f matrix3f = pPoseStack.last().normal();
            pPoseStack.pushPose();
            FluidStack fluidStack = pBlockEntity.getFluidTank().getFluid();
            Fluid fluid = fluidStack.getFluid();
            IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
            RenderUtil.buildCubeAll(new Vector3f(0.125f, 0.175f, 0.125f), new Vector3f(0.75f, pBlockEntity.getFullness() * 0.6875f, 0.75f), vertexConsumer, mat, matrix3f, fluidTypeExtensions.getTintColor(fluidStack), RenderUtil.getUV(fluidTypeExtensions.getStillTexture()), pPackedLight, pPackedOverlay, pPoseStack);
            pPoseStack.popPose();
        }
    }
}

