/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.meltingpot;

import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.ExtraDelightContainers;
import com.lance5057.extradelight.workstations.meltingpot.MeltingPotBlockEntity;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class MeltingPotMenu
extends AbstractContainerMenu {
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_BUCKET = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"item/empty_container_slot_bucket");
    public final MeltingPotBlockEntity tileEntity;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    protected MeltingPotMenu(int windowId, Inventory playerInventory, MeltingPotBlockEntity tileEntity) {
        super(ExtraDelightContainers.MELTING_POT_MENU.get(), windowId);
        this.tileEntity = tileEntity;
        this.level = playerInventory.player.level();
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)tileEntity.getLevel(), (BlockPos)tileEntity.getBlockPos());
        if (tileEntity != null) {
            int startX = 8;
            int startY = 8;
            int inputStartX = 64;
            int inputStartY = 5;
            int borderSlotSize = 18;
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)tileEntity.getItemHandler(), 0, 46, 23));
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)tileEntity.getItemHandler(), 1, 114, 26){

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_CONTAINER_SLOT_BUCKET);
                }
            });
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)tileEntity.getItemHandler(), 2, 114, 50));
            int startPlayerInvY = startY * 4 + 51;
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 9; ++column) {
                    this.addSlot(new Slot((Container)playerInventory, 9 + row * 9 + column, startX + column * borderSlotSize, startPlayerInvY + row * borderSlotSize));
                }
            }
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 141));
            }
        }
    }

    public MeltingPotMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, MeltingPotMenu.getTileEntity(playerInventory, data));
    }

    public FluidTank getFluidTank() {
        return this.tileEntity.getFluidTank();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        int indexOutput;
        int startPlayerInv = indexOutput = 2;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < startPlayerInv ? !this.moveItemStackTo(itemstack1, startPlayerInv, endPlayerInv, true) : !this.moveItemStackTo(itemstack1, 0, indexOutput, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public boolean stillValid(Player pPlayer) {
        return MeltingPotMenu.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)pPlayer, (Block)((Block)ExtraDelightBlocks.MELTING_POT.get()));
    }

    private static MeltingPotBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof MeltingPotBlockEntity) {
            return (MeltingPotBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }
}

