/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.mixingbowl;

import com.lance5057.extradelight.util.RenderUtil;
import com.lance5057.extradelight.workstations.FancyTank;
import com.lance5057.extradelight.workstations.mixingbowl.MixingBowlBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class MixingBowlRenderer
implements BlockEntityRenderer<MixingBowlBlockEntity> {
    int timer = 0;

    public MixingBowlRenderer(BlockEntityRendererProvider.Context cxt) {
    }

    public void render(MixingBowlBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        FancyTank mbt;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        IItemHandlerModifiable inv = pBlockEntity.getItemHandler();
        this.renderCircle(pBlockEntity, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, itemRenderer, (IItemHandler)inv, 0.0f, 35.0f, 0.2f, 0, 8);
        FancyTank fancyTank = pBlockEntity.getFluidTank();
        if (fancyTank instanceof FancyTank && !(mbt = fancyTank).getFluid().isEmpty()) {
            VertexConsumer vertexConsumer = pBufferSource.getBuffer(Sheets.translucentCullBlockSheet());
            Matrix4f mat = pPoseStack.last().pose();
            Matrix3f matrix3f = pPoseStack.last().normal();
            pPoseStack.pushPose();
            FluidStack fluidStack = mbt.getFluid();
            Fluid fluid = fluidStack.getFluid();
            IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
            float height = (float)fluidStack.getAmount() / 6000.0f * 0.25f + 0.1f;
            RenderUtil.buildPlane(new Vector3f(0.18f, height, 0.18f), new Vector3f(0.18f, height, 0.82f), new Vector3f(0.82f, height, 0.82f), new Vector3f(0.82f, height, 0.18f), vertexConsumer, mat, matrix3f, fluidTypeExtensions.getTintColor(fluidStack), RenderUtil.getUV(fluidTypeExtensions.getStillTexture()), Direction.UP.getNormal(), pPackedLight, pPackedOverlay, pPoseStack);
            pPoseStack.popPose();
        }
        ++this.timer;
    }

    private void renderCircle(MixingBowlBlockEntity pBlockEntity, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, ItemRenderer itemRenderer, @NotNull IItemHandler inv, float rotYoffset, float rotX, float transX, int start, int stop) {
        for (int i = start; i <= stop; ++i) {
            ItemStack item = inv.getStackInSlot(i);
            int g = pBlockEntity.getStirs();
            if (item.isEmpty()) continue;
            BakedModel bakedmodel = itemRenderer.getModel(item, pBlockEntity.getLevel(), null, 0);
            pPoseStack.pushPose();
            float rotY = i % 8 * 45 + g % 4 * 90;
            pPoseStack.translate(0.5f, 0.25f, 0.5f);
            pPoseStack.mulPose(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, rotYoffset + rotY));
            pPoseStack.translate(transX, 0.0f, 0.0f);
            pPoseStack.mulPose(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, 90.0f));
            pPoseStack.mulPose(new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, rotX));
            float uniscale = 0.65f;
            pPoseStack.scale(uniscale, uniscale, uniscale);
            itemRenderer.render(item, ItemDisplayContext.GROUND, false, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, bakedmodel);
            pPoseStack.popPose();
        }
    }
}

