/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.oven;

import com.lance5057.extradelight.workstations.oven.OvenMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import vectorwing.farmersdelight.common.utility.TextUtils;

@ParametersAreNonnullByDefault
public class OvenScreen
extends AbstractContainerScreen<OvenMenu> {
    private static final WidgetSprites RECIPE_BUTTON = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/button"), ResourceLocation.withDefaultNamespace((String)"recipe_book/button"));
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/oven.png");
    private static final Rectangle HEAT_ICON = new Rectangle(47, 55, 17, 15);
    private static final Rectangle PROGRESS_ARROW = new Rectangle(89, 25, 10, 17);

    public OvenScreen(OvenMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public void init() {
        super.init();
        this.titleLabelX = 28;
    }

    protected void containerTick() {
        super.containerTick();
    }

    public void render(GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(ms, partialTicks, mouseX, mouseY);
        super.render(ms, mouseX, mouseY, partialTicks);
        this.renderMealDisplayTooltip(ms, mouseX, mouseY);
    }

    private void renderHeatIndicatorTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        if (this.isHovering(OvenScreen.HEAT_ICON.x, OvenScreen.HEAT_ICON.y, OvenScreen.HEAT_ICON.width, OvenScreen.HEAT_ICON.height, mouseX, mouseY)) {
            String key = "container.cooking_pot." + (((OvenMenu)this.menu).isHeated() ? "heated" : "not_heated");
            gui.renderTooltip(this.font, (Component)TextUtils.getTranslation((String)key, (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void renderMealDisplayTooltip(GuiGraphics ms, int mouseX, int mouseY) {
        if (this.minecraft != null && this.minecraft.player != null && ((OvenMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            if (this.hoveredSlot.index == 6) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                ItemStack mealStack = this.hoveredSlot.getItem();
                tooltip.add(((MutableComponent)mealStack.getItem().getDescription()).withStyle(mealStack.getRarity().getStyleModifier()));
                ItemStack containerStack = ((OvenMenu)this.menu).tileEntity.getContainer();
                String container = !containerStack.isEmpty() ? containerStack.getItem().getDescription().getString() : "";
                tooltip.add(TextUtils.getTranslation((String)"container.cooking_pot.served_on", (Object[])new Object[]{container}).withStyle(ChatFormatting.GRAY));
                ms.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
            } else {
                ms.renderTooltip(this.font, this.hoveredSlot.getItem(), mouseX, mouseY);
            }
        }
    }

    protected void renderLabels(GuiGraphics ms, int mouseX, int mouseY) {
        super.renderLabels(ms, mouseX, mouseY);
        ms.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics ms, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.minecraft == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        ms.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight + 16);
        if (((OvenMenu)this.menu).isHeated()) {
            ms.blit(BACKGROUND_TEXTURE, this.leftPos + OvenScreen.HEAT_ICON.x + 77, this.topPos + OvenScreen.HEAT_ICON.y + 5, 176, 0, OvenScreen.HEAT_ICON.width, OvenScreen.HEAT_ICON.height);
        }
        int l = ((OvenMenu)this.menu).getCookProgressionScaled();
        ms.blit(BACKGROUND_TEXTURE, this.leftPos + OvenScreen.PROGRESS_ARROW.x, this.topPos + OvenScreen.PROGRESS_ARROW.y + 10, 176, 15, l + 1, OvenScreen.PROGRESS_ARROW.height + 7);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int x, int y, int buttonIdx) {
        boolean flag = mouseX < (double)x || mouseY < (double)y || mouseX >= (double)(x + this.imageWidth) || mouseY >= (double)(y + this.imageHeight);
        return flag;
    }

    protected void slotClicked(Slot slot, int mouseX, int mouseY, ClickType clickType) {
        super.slotClicked(slot, mouseX, mouseY, clickType);
    }
}

