/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.vat;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.ExtraDelightConfig;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.util.BlockEntityUtils;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.FancyTank;
import com.lance5057.extradelight.workstations.IFancyTankHandler;
import com.lance5057.extradelight.workstations.vat.recipes.VatRecipe;
import com.lance5057.extradelight.workstations.vat.recipes.VatRecipeWrapper;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class VatBlockEntity
extends BlockEntity
implements IFancyTankHandler<VatBlockEntity> {
    public static final String INV_TAG = "inv";
    private final ItemStackHandler items = this.createHandler();
    private final Lazy<IItemHandlerModifiable> itemHandler = Lazy.of(() -> this.items);
    public static final int CRAFT_SLOTS = 5;
    public static final int CONTAINER_SLOT = 6;
    public static final int FERMENTATION_INPUT_SLOT = 7;
    public static final int LIQUID_IN_SLOT = 8;
    public static final int LIQUID_OUT_SLOT = 9;
    public static final int OUTPUT_SLOT = 10;
    public static final String FLUID_TAG = "tank";
    private final FancyTank fluid = this.createFluidHandler();
    private int cookTime = 0;
    private int cookTimeTotal = 0;
    private int stage = 0;
    private int stageTotal = 0;
    private boolean lidRequired = false;
    private boolean hasLid = false;
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe;
    private final RecipeManager.CachedCheck<VatRecipeWrapper, VatRecipe> quickCheck = RecipeManager.createCheck(ExtraDelightRecipes.VAT.get());
    VatRecipe curRecipe;

    @Override
    public int getFluidInSlot() {
        return 8;
    }

    @Override
    public int getFluidOutSlot() {
        return 9;
    }

    public boolean isHasLid() {
        return this.hasLid;
    }

    public boolean isLidRequired() {
        return this.lidRequired;
    }

    public int getStageTotal() {
        return this.stageTotal;
    }

    public int getStage() {
        return this.stage;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    public VatBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ExtraDelightBlockEntities.VAT.get(), pPos, pState);
    }

    private FancyTank createFluidHandler() {
        FancyTank tank = new FancyTank(1000, e -> true, 1){

            @Override
            protected void onContentsChanged() {
                super.onContentsChanged();
                Level level = VatBlockEntity.this.getLevel();
                if (level == null) {
                    return;
                }
                VatBlockEntity.this.requestModelDataUpdate();
                level.sendBlockUpdated(VatBlockEntity.this.getBlockPos(), VatBlockEntity.this.getBlockState(), VatBlockEntity.this.getBlockState(), 3);
                VatBlockEntity.this.setChanged();
            }
        };
        return tank;
    }

    @Override
    public FancyTank getFluidTank() {
        return this.fluid;
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.itemHandler.get();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(11){

            public boolean isItemValid(int slot, ItemStack stack) {
                switch (slot) {
                    case 8: {
                        return stack.getCapability(Capabilities.FluidHandler.ITEM) != null || stack.is(Items.BUCKET) || !BottleFluidRegistry.getFluidFromBottle(stack).isEmpty();
                    }
                    case 9: {
                        return stack.getCapability(Capabilities.FluidHandler.ITEM) != null || stack.is(Items.BUCKET) || ItemStack.isSameItem((ItemStack)stack, (ItemStack)BottleFluidRegistry.getBottleFromFluid(VatBlockEntity.this.getFluidTank().drain(250, IFluidHandler.FluidAction.SIMULATE)).getCraftingRemainingItem()) || stack.is(Items.GLASS_BOTTLE);
                    }
                }
                return true;
            }

            protected void onContentsChanged(int slot) {
                if (slot == 8) {
                    VatBlockEntity.this.fillInternal(VatBlockEntity.this);
                }
                if (slot == 9) {
                    VatBlockEntity.this.drainInternal(VatBlockEntity.this);
                }
            }
        };
    }

    private boolean doesMealHaveContainer(ItemStack meal) {
        return meal.hasCraftingRemainingItem();
    }

    public int getLastFilledSlot(IItemHandlerModifiable inventory) {
        if (inventory.getStackInSlot(9) != ItemStack.EMPTY) {
            return 9;
        }
        for (int i = 0; i <= 9; ++i) {
            if (inventory.getStackInSlot(i) != ItemStack.EMPTY) continue;
            return i - 1;
        }
        return -1;
    }

    public void extractItem(Player playerEntity, IItemHandlerModifiable inventory) {
        int i = this.getLastFilledSlot(inventory);
        if (i != -1) {
            ItemStack itemStack = inventory.extractItem(i, 1, false);
            playerEntity.addItem(itemStack);
            this.updateInventory();
            return;
        }
        this.updateInventory();
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack slotStack = this.items.getStackInSlot(i);
            if (!slotStack.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        VatBlockEntity vat = (VatBlockEntity)be;
        if (level.isClientSide()) {
            RandomSource random = level.random;
            double x = (double)pos.getX() + 0.5 + (level.random.nextDouble() * 0.6 - 0.3);
            double y = (double)pos.getY() + 1.1;
            double z = (double)pos.getZ() + 0.5 + (level.random.nextDouble() * 0.6 - 0.3);
            if (vat.cookTime == 0 && vat.stage > 0 && random.nextFloat() < 0.2f) {
                level.addParticle((ParticleOptions)ParticleTypes.GLOW, x, y, z, 0.0, 0.0, 0.0);
            }
            if (vat.cookTime != 0 && vat.cookTime < vat.cookTimeTotal && random.nextFloat() < 0.5f) {
                level.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, x, y, z, 0.0, 1.0, 0.0);
            }
        } else {
            vat.hasLid = level.getBlockState(vat.worldPosition.above()).is(ExtraDelightBlocks.LID);
            RecipeHolder recipeholder = vat.quickCheck.getRecipeFor((RecipeInput)new VatRecipeWrapper((IItemHandler)vat.items, vat.fluid), level).orElse(null);
            if (recipeholder != null) {
                vat.stageTotal = ((VatRecipe)recipeholder.value()).getStages();
                if (vat.stage >= vat.stageTotal) {
                    ItemStack result = ((VatRecipe)recipeholder.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
                    ItemStack test = vat.items.insertItem(10, result, true);
                    if (test.isEmpty()) {
                        VatBlockEntity.dropContainers(state, vat, level);
                        VatBlockEntity.subtractItems(vat, result.getCount());
                        SizedFluidIngredient sfi = ((VatRecipe)recipeholder.value()).getFluid();
                        if (sfi.test(vat.fluid.getFluid())) {
                            vat.fluid.drain(sfi.amount(), IFluidHandler.FluidAction.EXECUTE);
                        }
                        BlockEntityUtils.Inventory.dropItemInWorld(vat.items.getStackInSlot(7).getCraftingRemainingItem().copy(), level, vat.getBlockPos());
                        vat.items.getStackInSlot(7).shrink(1);
                        vat.items.insertItem(10, result, false);
                        vat.cookTime = 0;
                        vat.stage = 0;
                    }
                } else {
                    vat.cookTimeTotal = ((VatRecipe.StageIngredient)((VatRecipe)recipeholder.value()).getStageIngredients().get((int)vat.stage)).time;
                    vat.lidRequired = ((VatRecipe.StageIngredient)((VatRecipe)recipeholder.value()).getStageIngredients().get((int)vat.stage)).lid;
                    vat.stageTotal = ((VatRecipe)recipeholder.value()).getStages();
                    if (vat.cookTime >= vat.cookTimeTotal) {
                        BlockEntityUtils.Inventory.dropItemInWorld(vat.items.getStackInSlot(7).getCraftingRemainingItem().copy(), level, vat.getBlockPos());
                        vat.items.getStackInSlot(7).shrink(1);
                        vat.cookTime = 0;
                        ++vat.stage;
                    } else if (!((VatRecipe)recipeholder.value()).getStageIngredients().isEmpty()) {
                        if (((VatRecipe)recipeholder.value()).getStageIngredients().size() > vat.stage && ((VatRecipe.StageIngredient)((VatRecipe)recipeholder.value()).getStageIngredients().get((int)vat.stage)).ingredient.test(vat.items.getStackInSlot(7))) {
                            if (((VatRecipe.StageIngredient)((VatRecipe)recipeholder.value()).getStageIngredients().get((int)vat.stage)).lid) {
                                if (vat.hasLid) {
                                    VatBlockEntity.increaseCookTime(vat);
                                }
                            } else if (!level.getBlockState(vat.worldPosition.above()).is(ExtraDelightBlocks.LID)) {
                                VatBlockEntity.increaseCookTime(vat);
                            }
                        }
                    } else {
                        VatBlockEntity.increaseCookTime(vat);
                    }
                }
            } else {
                vat.cookTime = 0;
                vat.cookTimeTotal = 0;
            }
            vat.updateInventory();
        }
    }

    static void increaseCookTime(VatBlockEntity vat) {
        vat.cookTime = ExtraDelightConfig.ENABLE_DEBUG_MODE.isFalse() ? ++vat.cookTime : (vat.cookTime += 1000);
    }

    private static void subtractItems(VatBlockEntity chiller, int k) {
        ItemStackHandler i = chiller.items;
        i.getStackInSlot(6).shrink(k);
        for (int j = 0; j < 6; ++j) {
            i.getStackInSlot(j).shrink(1);
        }
    }

    private static void dropContainers(BlockState state, @NotNull VatBlockEntity chiller, Level level) {
        double x = chiller.worldPosition.getX();
        double y = (double)chiller.worldPosition.getY() + 0.7;
        double z = chiller.worldPosition.getZ();
        for (int i = 0; i < 6; ++i) {
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)chiller.items.getStackInSlot(i).copy().getCraftingRemainingItem().copy(), (double)x, (double)y, (double)z, (double)0.0, (double)0.0, (double)0.0);
        }
    }

    @Override
    public void updateInventory() {
        this.setupRecipe();
        this.requestModelDataUpdate();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    private void setupRecipe() {
        Optional<RecipeHolder<VatRecipe>> recipe = this.matchRecipe();
        this.curRecipe = recipe.isPresent() ? (VatRecipe)recipe.get().value() : null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains(INV_TAG)) {
            this.items.deserializeNBT(registries, nbt.getCompound(INV_TAG));
        }
        this.getFluidTank().readFromNBT(registries, nbt);
        this.stage = nbt.getInt("stage");
        this.stageTotal = nbt.getInt("stageTotal");
        this.cookTime = nbt.getInt("cookTime");
        this.cookTimeTotal = nbt.getInt("cookTimeTotal");
        this.lidRequired = nbt.getBoolean("needsLid");
        this.hasLid = nbt.getBoolean("hasLid");
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(INV_TAG, (Tag)this.items.serializeNBT(registries));
        this.getFluidTank().writeToNBT(registries, tag);
        tag.putInt("stage", this.stage);
        tag.putInt("stageTotal", this.stageTotal);
        tag.putInt("cookTime", this.cookTime);
        tag.putInt("cookTimeTotal", this.cookTimeTotal);
        tag.putBoolean("needsLid", this.lidRequired);
        tag.putBoolean("hasLid", this.hasLid);
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }

    protected Optional<RecipeHolder<VatRecipe>> matchRecipe() {
        if (this.level != null) {
            Optional recipe = this.level.getRecipeManager().getRecipeFor(ExtraDelightRecipes.VAT.get(), (RecipeInput)new VatRecipeWrapper(this, (IItemHandler)this.items, this.fluid){

                public int size() {
                    return 9;
                }
            }, this.level);
            return recipe;
        }
        return Optional.empty();
    }
}

