/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.util;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivemetalworks.common.datamap.FuelMap;
import cy.jdkdigital.productivemetalworks.common.datamap.UnitMap;
import cy.jdkdigital.productivemetalworks.recipe.ItemMeltingRecipe;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.util.RecipeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class FluidHelper {
    static Map<Item, FluidStack> itemToFluidCache = new HashMap<Item, FluidStack>();

    public static FluidStack itemToFluid(Level level, ItemStack itemStack) {
        RecipeHolder<ItemMeltingRecipe> meltingRecipe;
        if (!itemToFluidCache.containsKey(itemStack.getItem()) && (meltingRecipe = RecipeHelper.getItemMeltingRecipe(level, itemStack, new FuelMap(100000, 1.0f, 1.0f))) != null && ((ItemMeltingRecipe)meltingRecipe.value()).result.size() == 1) {
            itemToFluidCache.put(itemStack.getItem(), ((ItemMeltingRecipe)meltingRecipe.value()).result.getFirst().copy());
        }
        return itemToFluidCache.getOrDefault(itemStack.getItem(), null);
    }

    public static Map<Fluid, Pair<ItemStack, Integer>> materialsToFluids(Level level, Stream<ItemStack> items, int materialCount) {
        HashMap<Fluid, Pair<ItemStack, Integer>> fluids = new HashMap<Fluid, Pair<ItemStack, Integer>>();
        items.forEach(stack -> {
            FluidStack fluid;
            if (!(stack.isEmpty() || stack.is(Items.BARRIER) || (fluid = FluidHelper.itemToFluid(level, stack)) == null || fluids.containsKey(fluid.getFluid()))) {
                fluids.put(fluid.getFluid(), Pair.of((Object)stack, (Object)(fluid.getAmount() * materialCount)));
            }
        });
        return fluids;
    }

    public static List<Component> formatTooltip(SizedFluidIngredient fluidIngredient) {
        FluidStack firstFluid = fluidIngredient.getFluids()[0];
        return FluidHelper.formatTooltip(new FluidStack(firstFluid.getFluid(), fluidIngredient.amount()));
    }

    public static List<Component> formatTooltip(FluidStack fluidStack) {
        UnitMap units;
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (!fluidStack.isEmpty() && (units = (UnitMap)fluidStack.getFluid().builtInRegistryHolder().getData(MetalworksRegistrator.UNIT_MAP)) != null) {
            int[] amountLeft = new int[]{fluidStack.getAmount()};
            units.units().reversed().forEach(unit -> {
                double numberOfThisUnit = Math.floor((double)amountLeft[0] / (double)unit.amount());
                if (numberOfThisUnit > 0.0) {
                    tooltips.add((Component)Component.translatable((String)("productivemetalworks.unit." + unit.unit() + "." + (numberOfThisUnit == 1.0 ? "single" : "multiple")), (Object[])new Object[]{(int)numberOfThisUnit}));
                    amountLeft[0] = amountLeft[0] - (int)numberOfThisUnit * unit.amount();
                }
            });
            if (amountLeft[0] > 0) {
                tooltips.add((Component)Component.translatable((String)"productivemetalworks.unit.leftover", (Object[])new Object[]{amountLeft[0]}));
            }
        }
        return tooltips;
    }
}

