/*
 * Decompiled with CFR 0.152.
 */
package cn.dancingsnow.bigger_ae2;

import appeng.api.AECapabilities;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import cn.dancingsnow.bigger_ae2.data.generator.BiggerAE2Datagen;
import cn.dancingsnow.bigger_ae2.init.ModBlockEntities;
import cn.dancingsnow.bigger_ae2.init.ModBlocks;
import cn.dancingsnow.bigger_ae2.init.ModComponents;
import cn.dancingsnow.bigger_ae2.init.ModCreativeTab;
import cn.dancingsnow.bigger_ae2.init.ModItems;
import cn.dancingsnow.bigger_ae2.integration.appliedexperienced.AppliedExperiencedItems;
import cn.dancingsnow.bigger_ae2.integration.appliedflux.AppliedFluxItems;
import cn.dancingsnow.bigger_ae2.integration.appliedmekanistics.AppliedMekanisticsItems;
import cn.dancingsnow.bigger_ae2.integration.arsenergistique.ArsEnergistiqueItems;
import cn.dancingsnow.bigger_ae2.item.cell.DigitalSingularityCellItem;
import com.mojang.logging.LogUtils;
import com.tterrag.registrate.Registrate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import org.slf4j.Logger;

@Mod(value="bigger_ae2")
public class BiggerAE2Mod {
    public static final String MOD_ID = "bigger_ae2";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Registrate REGISTRATE = Registrate.create((String)"bigger_ae2");

    public BiggerAE2Mod(IEventBus modEventBus) {
        ModCreativeTab.register();
        ModItems.register();
        ModBlocks.register();
        ModBlockEntities.register();
        ModComponents.register(modEventBus);
        if (ModList.get().isLoaded("appflux")) {
            AppliedFluxItems.register();
        } else {
            LOGGER.debug("Applied Flux not installed, passed");
        }
        if (ModList.get().isLoaded("appmek")) {
            AppliedMekanisticsItems.register();
        } else {
            LOGGER.debug("Applied Mekanistics not installed, passed");
        }
        if (ModList.get().isLoaded("arseng")) {
            ArsEnergistiqueItems.register();
        } else {
            LOGGER.debug("Ars ArsEnergistique not installed, passed");
        }
        if (ModList.get().isLoaded("appex")) {
            AppliedExperiencedItems.register();
        } else {
            LOGGER.debug("Applied Experienced not installed, passed");
        }
        modEventBus.addListener(BiggerAE2Mod::initUpgrades);
        modEventBus.addListener(BiggerAE2Mod::initStorageCells);
        modEventBus.addListener(BiggerAE2Mod::packSetup);
        modEventBus.addListener(BiggerAE2Mod::registerCapabilities);
        BiggerAE2Datagen.init();
    }

    public static ResourceLocation of(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private static void initUpgrades(FMLCommonSetupEvent event) {
        String storageCellGroup = GuiText.StorageCells.getTranslationKey();
        Upgrades.add((ItemLike)AEItems.VOID_CARD, ModItems.QUANTUM_ITEM_CELL, (int)1, (String)storageCellGroup);
        Upgrades.add((ItemLike)AEItems.VOID_CARD, ModItems.SINGULARITY_ITEM_CELL, (int)1, (String)storageCellGroup);
        Upgrades.add((ItemLike)AEItems.VOID_CARD, ModItems.QUANTUM_FLUID_CELL, (int)1, (String)storageCellGroup);
        Upgrades.add((ItemLike)AEItems.VOID_CARD, ModItems.SINGULARITY_FLUID_CELL, (int)1, (String)storageCellGroup);
    }

    private static void initStorageCells(FMLCommonSetupEvent event) {
        StorageCells.addCellHandler((ICellHandler)DigitalSingularityCellItem.HANDLER);
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, (BlockEntityType)ModBlockEntities.CRAFTING_ACCELERATOR.get(), (o, unused) -> o);
    }

    private static void packSetup(AddPackFindersEvent event) {
        event.addPackFinders(BiggerAE2Mod.of("builtin_pack"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"bigger_ae2.old_pack"), PackSource.BUILT_IN, false, Pack.Position.TOP);
    }
}

