/*
 * Decompiled with CFR 0.152.
 */
package cn.dancingsnow.bigger_ae2.item.cell;

import appeng.api.stacks.AEKey;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.math.BigInteger;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public class DigitalSingularityStorage {
    public static final Codec<DigitalSingularityStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AEKey.CODEC.fieldOf("key").forGetter(DigitalSingularityStorage::getStoredItem), (App)Codec.STRING.flatXmap(it -> {
        try {
            return DataResult.success((Object)new BigInteger((String)it));
        }
        catch (NumberFormatException e) {
            return DataResult.success((Object)BigInteger.ZERO);
        }
    }, it -> DataResult.success((Object)it.toString())).fieldOf("count").forGetter(DigitalSingularityStorage::getCount)).apply((Applicative)instance, DigitalSingularityStorage::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DigitalSingularityStorage> STREAM_CODEC = StreamCodec.ofMember(DigitalSingularityStorage::encode, DigitalSingularityStorage::new);
    @Nullable
    private final AEKey storedItem;
    private final BigInteger count;

    public DigitalSingularityStorage(@Nullable AEKey storedItem, BigInteger count) {
        this.storedItem = storedItem;
        this.count = count;
    }

    public DigitalSingularityStorage(RegistryFriendlyByteBuf buf) {
        BigInteger c;
        this.storedItem = AEKey.readOptionalKey((RegistryFriendlyByteBuf)buf);
        String integerStr = buf.readUtf();
        try {
            c = new BigInteger(integerStr);
        }
        catch (NumberFormatException e) {
            c = BigInteger.ZERO;
        }
        this.count = c;
    }

    public void encode(RegistryFriendlyByteBuf buf) {
        AEKey.writeOptionalKey((RegistryFriendlyByteBuf)buf, (AEKey)this.storedItem);
        buf.writeUtf(this.count.toString());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DigitalSingularityStorage) {
            DigitalSingularityStorage storage = (DigitalSingularityStorage)obj;
            return Objects.equals(storage.getStoredItem(), this.getStoredItem()) && Objects.equals(storage.getCount(), this.getCount());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getStoredItem(), this.getCount());
    }

    @Nullable
    public AEKey getStoredItem() {
        return this.storedItem;
    }

    public BigInteger getCount() {
        return this.count;
    }
}

