/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.Pair;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class EmoteListWidget
extends ObjectSelectionList<EmoteEntry> {
    protected List<EmoteEntry> emotes = new ArrayList<EmoteEntry>();
    private boolean compactMode;

    public EmoteListWidget(Minecraft minecraftClient, int i, int j, int k, int l) {
        super(minecraftClient, i, j, k, l);
        this.centerListVertically = false;
    }

    public int getRowWidth() {
        if (this.compactMode) {
            return this.width;
        }
        return this.width / 2;
    }

    protected int getScrollbarPosition() {
        if (!this.compactMode) {
            return super.getScrollbarPosition();
        }
        return this.getX() + this.getRowWidth() - 6;
    }

    protected void renderSelection(@NotNull GuiGraphics guiGraphics, int i, int j, int k, int l, int m) {
        if (this.compactMode && this.scrollbarVisible()) {
            int o = this.getRowLeft() - 2;
            int p = this.getRight() - 6 - 1;
            int q = i - 2;
            int r = i + k + 2;
            guiGraphics.fill(o, q, p, r, l);
            guiGraphics.fill(o + 1, q + 1, p - 1, r - 1, m);
        } else {
            super.renderSelection(guiGraphics, i, j, k, l, m);
        }
    }

    protected void renderItem(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        try {
            super.renderItem(guiGraphics, mouseX, mouseY, partialTick, index, left, top, width, height);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setEmotes(Iterable<EmoteHolder> list, boolean showInvalid) {
        this.emotes.clear();
        for (EmoteHolder emoteHolder : list) {
            this.emotes.add(new EmoteEntry(emoteHolder));
        }
        if (showInvalid) {
            for (EmoteHolder emoteHolder : this.getEmptyEmotes()) {
                this.emotes.add(new EmoteEntry(emoteHolder));
            }
        }
        this.emotes.sort(Comparator.comparing(o -> o.emote.name.getString().toLowerCase()));
        this.filter(() -> "");
    }

    public void filter(Supplier<String> string) {
        this.clearEntries();
        for (EmoteEntry emote : this.emotes) {
            if (!emote.emote.name.getString().toLowerCase().contains(string.get()) && !emote.emote.description.getString().toLowerCase().contains(string.get()) && !emote.emote.author.getString().toLowerCase().equals(string.get())) continue;
            this.addEntry((AbstractSelectionList.Entry)emote);
        }
        this.setScrollAmount(0.0);
    }

    public Iterable<EmoteHolder> getEmptyEmotes() {
        LinkedList<EmoteHolder> empties = new LinkedList<EmoteHolder>();
        for (Pair<UUID, InputConstants.Key> pair : ((ClientConfig)EmoteInstance.config).emoteKeyMap) {
            if (EmoteHolder.list.containsKey(pair.getLeft())) continue;
            empties.add(new EmoteHolder.Empty((UUID)pair.getLeft()));
        }
        return empties;
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    public class EmoteEntry
    extends ObjectSelectionList.Entry<EmoteEntry> {
        public final EmoteHolder emote;

        public EmoteEntry(EmoteHolder emote) {
            this.emote = emote;
        }

        public void render(@NotNull GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            ResourceLocation texture;
            int maxX = x + entryWidth - 3 - (EmoteListWidget.this.compactMode && EmoteListWidget.this.scrollbarVisible() ? 7 : 0);
            matrices.enableScissor(x - 1, y - 1, maxX, y + entryHeight + 1);
            if (hovered) {
                matrices.fill(x - 1, y - 1, maxX, y + entryHeight + 1, MathHelper.colorHelper((int)66, (int)66, (int)66, (int)128));
            }
            Font font = ((EmoteListWidget)EmoteListWidget.this).minecraft.font;
            Component component = this.emote.name;
            Objects.requireNonNull(((EmoteListWidget)EmoteListWidget.this).minecraft.font);
            EmoteListWidget.renderScrollingString((GuiGraphics)matrices, (Font)font, (Component)component, (int)(x + 34), (int)(x + 34), (int)(y + 1), (int)maxX, (int)(y + 1 + 9), (int)0xFFFFFF);
            matrices.drawString(((EmoteListWidget)EmoteListWidget.this).minecraft.font, this.emote.description, x + 34, y + 12, 0x808080);
            if (!this.emote.author.getString().isEmpty()) {
                MutableComponent text = Component.translatable((String)"emotecraft.emote.author").withStyle(ChatFormatting.GOLD).append(this.emote.author);
                matrices.drawString(((EmoteListWidget)EmoteListWidget.this).minecraft.font, (Component)text, x + 34, y + 23, 0x808080);
            }
            if ((texture = this.emote.getIconIdentifier()) != null) {
                RenderSystem.enableBlend();
                matrices.blit(texture, x, y, 32, 32, 0.0f, 0.0f, 256, 256, 256, 256);
                RenderSystem.disableBlend();
            }
            matrices.disableScissor();
        }

        public EmoteHolder getEmote() {
            return this.emote;
        }

        @NotNull
        public Component getNarration() {
            return this.emote.name;
        }
    }
}

