/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import java.nio.ByteBuffer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public record EmotePacketPayload(@NotNull CustomPacketPayload.Type<?> id, @NotNull ByteBuffer bytes) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, EmotePacketPayload> EMOTE_CHANNEL_READER = EmotePacketPayload.reader(NetworkPlatformTools.EMOTE_CHANNEL_ID);
    public static final StreamCodec<FriendlyByteBuf, EmotePacketPayload> STREAM_CHANNEL_READER = EmotePacketPayload.reader(NetworkPlatformTools.STREAM_CHANNEL_ID);
    public static final StreamCodec<FriendlyByteBuf, EmotePacketPayload> GEYSER_CHANNEL_READER = EmotePacketPayload.reader(NetworkPlatformTools.GEYSER_CHANNEL_ID);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return this.id;
    }

    public byte[] unwrapBytes() {
        return INetworkInstance.safeGetBytesFromBuffer(this.bytes());
    }

    @NotNull
    public static CustomPacketPayload playPacket(@NotNull ByteBuffer bytes) {
        return new EmotePacketPayload(NetworkPlatformTools.EMOTE_CHANNEL_ID, bytes);
    }

    @NotNull
    public static CustomPacketPayload streamPacket(@NotNull ByteBuffer bytes) {
        return new EmotePacketPayload(NetworkPlatformTools.STREAM_CHANNEL_ID, bytes);
    }

    @NotNull
    public static CustomPacketPayload geyserPacket(@NotNull ByteBuffer bytes) {
        return new EmotePacketPayload(NetworkPlatformTools.GEYSER_CHANNEL_ID, bytes);
    }

    @NotNull
    public static StreamCodec<FriendlyByteBuf, EmotePacketPayload> reader(@NotNull CustomPacketPayload.Type<?> channel) {
        return CustomPacketPayload.codec((payload, buf) -> buf.writeBytes(payload.unwrapBytes()), buf -> {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            return new EmotePacketPayload(channel, ByteBuffer.wrap(bytes));
        });
    }
}

