/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import io.github.kosmx.emotes.arch.mixin.ServerCommonPacketListenerAccessor;
import io.github.kosmx.emotes.arch.network.AbstractServerNetwork;
import io.github.kosmx.emotes.arch.network.EmotesMixinConnection;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.server.network.EmotePlayTracker;
import io.github.kosmx.emotes.server.network.IServerNetworkInstance;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModdedServerPlayNetwork
extends AbstractServerNetwork
implements IServerNetworkInstance {
    @NotNull
    private final ServerGamePacketListenerImpl serverGamePacketListener;
    @NotNull
    private final EmotePlayTracker emotePlayTracker = new EmotePlayTracker();

    public ModdedServerPlayNetwork(@NotNull ServerGamePacketListenerImpl serverGamePacketListener) {
        this.serverGamePacketListener = serverGamePacketListener;
    }

    @Override
    @NotNull
    protected EmotesMixinConnection getServerConnection() {
        return (EmotesMixinConnection)((ServerCommonPacketListenerAccessor)this.serverGamePacketListener).getConnection();
    }

    @Override
    void sendEmotePacket(ByteBuffer buffer) {
        this.sendPlayMessage(buffer);
    }

    @Override
    public void sendGeyserPacket(ByteBuffer buffer) {
        this.serverGamePacketListener.send(NetworkPlatformTools.geyserPacket(buffer));
    }

    @Override
    public void disconnect(String literal) {
        this.serverGamePacketListener.disconnect((Component)Component.literal((String)literal));
    }

    @Override
    void sendStreamPacket(ByteBuffer buffer) {
        this.serverGamePacketListener.send(NetworkPlatformTools.streamPacket(buffer));
    }

    @Override
    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        this.sendPlayMessage(builder.setVersion(this.getRemoteVersions()).build().write());
    }

    public void sendPlayMessage(ByteBuffer bytes) {
        this.serverGamePacketListener.send(NetworkPlatformTools.playPacket(bytes));
    }

    public void sendPlayStream(ByteBuffer bytes) {
        if (this.getRemoteVersions().getOrDefault((byte)-127, (byte)1) != 0) {
            this.streamHelper.sendMessage(bytes);
        } else {
            this.sendPlayMessage(bytes);
        }
    }

    @Override
    public EmotePlayTracker getEmoteTracker() {
        return this.emotePlayTracker;
    }
}

