/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;

public class BeachGrassBlock
extends BushBlock {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    protected MapCodec<? extends BushBlock> codec() {
        return BeachGrassBlock.simpleCodec(BeachGrassBlock::new);
    }

    public BeachGrassBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public VoxelShape getShape(BlockState blockstate, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState ground = pLevel.getBlockState(pPos.below());
        TriState soilDecision = ground.canSustainPlant((BlockGetter)pLevel, pPos.below(), Direction.UP, pState);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return ground.is(BlockTags.SAND);
    }
}

