/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features;

import com.mojang.serialization.Codec;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.configurations.BushConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class BushFeature
extends Feature<BushConfiguration> {
    public BushFeature(Codec<BushConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BushConfiguration> context) {
        BlockPos origin;
        WorldGenLevel world = context.level();
        if (world.isEmptyBlock(origin = context.origin()) && (world.getBlockState(origin.below()).is(Blocks.GRASS_BLOCK) || world.getBlockState(origin.below()).is(BlockTags.DIRT))) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (world.getBlockState(origin.offset(dir.getNormal())).canBeReplaced()) continue;
                return false;
            }
            world.setBlock(origin, ((BushConfiguration)context.config()).log(), 2);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                world.setBlock(origin.offset(dir.getNormal()), (BlockState)((BushConfiguration)context.config()).leaves().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
            }
            world.setBlock(origin.above(), (BlockState)((BushConfiguration)context.config()).leaves().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }
}

