/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features;

import com.mojang.serialization.Codec;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.configurations.MultipleVegetationPatchConfiguration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.Fluids;

public class MultipleWaterloggedVegetationPatchFeature
extends Feature<MultipleVegetationPatchConfiguration> {
    public MultipleWaterloggedVegetationPatchFeature(Codec<MultipleVegetationPatchConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<MultipleVegetationPatchConfiguration> context) {
        WorldGenLevel worldgenlevel = context.level();
        MultipleVegetationPatchConfiguration config = (MultipleVegetationPatchConfiguration)context.config();
        RandomSource random = context.random();
        if (random.nextFloat() > config.placementChance) {
            return false;
        }
        BlockPos blockpos = context.origin();
        Predicate<BlockState> predicate = p_204782_ -> p_204782_.is(config.replaceable);
        int i = config.xzRadius.sample(random) + 1;
        int j = config.xzRadius.sample(random) + 1;
        Set<BlockPos> set = this.placeGroundPatch(worldgenlevel, config, random, blockpos, predicate, i, j);
        this.distributeVegetation(context, worldgenlevel, config, random, set, i, j);
        return !set.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(WorldGenLevel level, MultipleVegetationPatchConfiguration config, RandomSource rand, BlockPos pos, Predicate<BlockState> replace, int x, int z) {
        Set<BlockPos> set = this.createGround(level, config, rand, pos, replace, x, z);
        HashSet<BlockPos> set1 = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : set) {
            if (MultipleWaterloggedVegetationPatchFeature.isExposed(level, set, blockpos, blockpos$mutableblockpos)) continue;
            set1.add(blockpos);
        }
        for (BlockPos blockpos1 : set1) {
            level.setBlock(blockpos1, Blocks.WATER.defaultBlockState(), 2);
        }
        return set1;
    }

    private static boolean isExposed(WorldGenLevel level, Set<BlockPos> set, BlockPos pos, BlockPos.MutableBlockPos posMutable) {
        return MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, Direction.NORTH) || MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, Direction.EAST) || MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, Direction.SOUTH) || MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, Direction.WEST) || MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, Direction.DOWN);
    }

    private static boolean isExposedDirection(WorldGenLevel level, BlockPos pos, BlockPos.MutableBlockPos posMutable, Direction dir) {
        posMutable.setWithOffset((Vec3i)pos, dir);
        return !level.getBlockState((BlockPos)posMutable).isFaceSturdy((BlockGetter)level, (BlockPos)posMutable, dir.getOpposite());
    }

    protected Set<BlockPos> createGround(WorldGenLevel level, MultipleVegetationPatchConfiguration config, RandomSource rand, BlockPos pos, Predicate<BlockState> predicate, int x, int z) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        this.carve(set, level, config, rand, pos, predicate, x, z, true);
        this.carve(set, level, config, rand, pos.below(), predicate, x - 1, z - 1, false);
        return set;
    }

    private void carve(Set<BlockPos> set, WorldGenLevel level, MultipleVegetationPatchConfiguration config, RandomSource rand, BlockPos pos, Predicate<BlockState> predicate, int x, int z, boolean surface) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = blockpos$mutableblockpos.mutable();
        Direction direction = config.surface.getDirection();
        Direction direction1 = direction.getOpposite();
        for (int i = -x; i <= x; ++i) {
            boolean flag = i == -x || i == x;
            for (int j = -z; j <= z; ++j) {
                boolean flag4;
                boolean flag1 = j == -z || j == z;
                boolean flag2 = flag || flag1;
                boolean flag3 = flag && flag1;
                boolean bl = flag4 = flag2 && !flag3;
                if (flag3 || flag4 && (config.extraEdgeColumnChance == 0.0f || rand.nextFloat() > config.extraEdgeColumnChance)) continue;
                blockpos$mutableblockpos.setWithOffset((Vec3i)pos, i, 0, j);
                for (int k = 0; (!surface || level.isStateAtPosition((BlockPos)blockpos$mutableblockpos, BlockBehaviour.BlockStateBase::isAir)) && k < config.verticalRange; ++k) {
                    blockpos$mutableblockpos.move(direction);
                }
                for (int i1 = 0; level.isStateAtPosition((BlockPos)blockpos$mutableblockpos, p_204784_ -> !p_204784_.isAir()) && i1 < config.verticalRange; ++i1) {
                    blockpos$mutableblockpos.move(direction1);
                }
                blockpos$mutableblockpos1.setWithOffset((Vec3i)blockpos$mutableblockpos, config.surface.getDirection());
                BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos1);
                if (!blockstate.isFaceSturdy((BlockGetter)level, (BlockPos)blockpos$mutableblockpos1, config.surface.getDirection().getOpposite())) continue;
                int l = config.depth.sample(rand) + (config.extraBottomBlockChance > 0.0f && rand.nextFloat() < config.extraBottomBlockChance ? 1 : 0);
                BlockPos blockpos = blockpos$mutableblockpos1.immutable();
                boolean flag5 = this.placeGround(level, config, predicate, rand, blockpos$mutableblockpos1, l);
                if (!flag5) continue;
                set.add(blockpos);
            }
        }
    }

    protected void distributeVegetation(FeaturePlaceContext<MultipleVegetationPatchConfiguration> context, WorldGenLevel level, MultipleVegetationPatchConfiguration config, RandomSource rand, Set<BlockPos> set, int p_160619_, int p_160620_) {
        for (BlockPos blockpos : set) {
            if (config.vegetationChance > 0.0f && rand.nextFloat() < config.vegetationChance) {
                this.placeVegetation(level, config, context.chunkGenerator(), rand, blockpos);
                if (rand.nextInt(20) != 0) continue;
                for (int i = 0; i < 32; ++i) {
                    BlockPos pos = blockpos;
                    BlockState blockstate = Blocks.SEAGRASS.defaultBlockState();
                    for (int j = 0; j < i / 16; ++j) {
                        if (!level.getBlockState((pos = pos.offset(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).below()).isCollisionShapeFullBlock((BlockGetter)level, pos.below()) || !blockstate.canSurvive((LevelReader)level, pos)) continue;
                        BlockState blockstate1 = level.getBlockState(pos);
                        if (blockstate1.is(Blocks.WATER) && level.getFluidState(pos).getAmount() == 8) {
                            level.setBlock(pos, blockstate, 3);
                            continue;
                        }
                        if (blockstate1.is(Blocks.KELP) && rand.nextBoolean()) {
                            int l = Math.min((Integer)blockstate1.getValue((Property)GrowingPlantHeadBlock.AGE) + 1, 25);
                            if (level.getBlockState(pos.above()).getFluidState().getType() != Fluids.WATER) continue;
                            level.setBlock(pos, (BlockState)blockstate1.setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(l)), 3);
                            continue;
                        }
                        if (!blockstate1.is(Blocks.SEAGRASS) || rand.nextInt(3) != 0 || level.getBlockState(pos.above()).getFluidState().getType() != Fluids.WATER) continue;
                        level.setBlock(pos, Blocks.TALL_SEAGRASS.defaultBlockState(), 3);
                    }
                }
                continue;
            }
            if (level.getFluidState(blockpos).getType() != Fluids.WATER || level.getBlockState(blockpos).getBlock() != Blocks.WATER || !(rand.nextFloat() < 0.25f)) continue;
            this.tryPlaceCoral(level, blockpos, rand);
        }
    }

    private void tryPlaceCoral(WorldGenLevel level, BlockPos pos, RandomSource rand) {
        if (level.getBlockState(pos.below()).isCollisionShapeFullBlock((BlockGetter)level, pos.below())) {
            Optional optional;
            if (rand.nextBoolean() && (optional = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.CORALS, rand)).isPresent()) {
                optional.ifPresent(holder -> {
                    BlockState blockstate = ((Block)holder.value()).defaultBlockState();
                    level.setBlock(pos, blockstate, 2);
                });
            }
        } else {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Optional optional;
                if (!rand.nextBoolean() || !level.getBlockState(pos.relative(direction)).isCollisionShapeFullBlock((BlockGetter)level, pos.relative(direction)) || !(optional = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.WALL_CORALS, rand)).isPresent()) continue;
                optional.ifPresent(holder -> {
                    BlockState blockstate = ((Block)holder.value()).defaultBlockState();
                    if (blockstate.hasProperty((Property)BaseCoralWallFanBlock.FACING)) {
                        blockstate = (BlockState)blockstate.setValue((Property)BaseCoralWallFanBlock.FACING, (Comparable)direction.getOpposite());
                        level.setBlock(pos, blockstate, 2);
                    }
                });
            }
        }
    }

    protected boolean placeVegetation(WorldGenLevel level, MultipleVegetationPatchConfiguration config, ChunkGenerator chunkGenerator, RandomSource rand, BlockPos pos) {
        boolean flag = false;
        for (Holder<PlacedFeature> feature : config.vegetationFeature) {
            if (!((PlacedFeature)feature.value()).place(level, chunkGenerator, rand, pos.below().relative(config.surface.getDirection().getOpposite()))) continue;
            BlockState blockstate = level.getBlockState(pos);
            if (blockstate.hasProperty((Property)BlockStateProperties.WATERLOGGED) && !((Boolean)blockstate.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                level.setBlock(pos, (BlockState)blockstate.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
            }
            flag = true;
        }
        return flag;
    }

    protected boolean placeGround(WorldGenLevel level, MultipleVegetationPatchConfiguration config, Predicate<BlockState> pred, RandomSource rand, BlockPos.MutableBlockPos pos, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            BlockState blockstate1;
            BlockState blockstate = config.groundState.getState(rand, (BlockPos)pos);
            if (blockstate.is((blockstate1 = level.getBlockState((BlockPos)pos)).getBlock())) continue;
            if (!pred.test(blockstate1)) {
                return i != 0;
            }
            level.setBlock((BlockPos)pos, blockstate, 2);
            pos.move(config.surface.getDirection());
        }
        return true;
    }
}

