/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal;

import dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal.RuinedPortalDecoratorBase;
import dev.orderedchaos.projectvibrantjourneys.core.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.jetbrains.annotations.Nullable;

public class SoulSandValleyRuinedPortalDecorator
extends RuinedPortalDecoratorBase {
    public SoulSandValleyRuinedPortalDecorator() {
        super("soul_sand_valley_ruined_portal_decorator");
    }

    @Override
    @Nullable
    public BlockState getTopSoil(WorldGenLevel level, RandomSource random) {
        float oreChance = random.nextFloat();
        if (oreChance < 0.5f) {
            return Blocks.SOUL_SAND.defaultBlockState();
        }
        return Blocks.SOUL_SOIL.defaultBlockState();
    }

    @Override
    @Nullable
    public BlockState getFillerSoil(WorldGenLevel level, RandomSource random) {
        return Blocks.SOUL_SAND.defaultBlockState();
    }

    @Override
    public void decorate(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos groundPos) {
        float chance = random.nextFloat();
        if (chance < 0.15f) {
            level.setBlock(groundPos.above(), Blocks.SOUL_FIRE.defaultBlockState(), 2);
        } else if (chance < 0.18f) {
            BlockPos pos;
            int height = 3 + random.nextInt(3);
            boolean placeExtraBlock = false;
            for (int i = 1; i <= height && LevelUtils.isEmptyOrReplaceable((ServerLevelAccessor)level, pos = groundPos.above(i)); ++i) {
                level.setBlock(pos, Blocks.BONE_BLOCK.defaultBlockState(), 2);
                if (i != height) continue;
                placeExtraBlock = random.nextBoolean();
            }
            if (placeExtraBlock) {
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                pos = groundPos.above(height).offset(direction.getNormal()).above(random.nextBoolean() ? 1 : 0);
                if (LevelUtils.isEmptyOrReplaceable((ServerLevelAccessor)level, pos)) {
                    level.setBlock(pos, Blocks.BONE_BLOCK.defaultBlockState(), 2);
                }
            }
        }
    }
}

