/*
 * Decompiled with CFR 0.152.
 */
package net.enchant_limiter.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.enchant_limiter.api.ItemComponentTypes;
import net.enchant_limiter.api.LimitComponent;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilScreenHandlerMixin
extends ItemCombinerMenu {
    @Shadow
    @Final
    private DataSlot cost;

    public AnvilScreenHandlerMixin(@Nullable MenuType<?> type, int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super(type, syncId, playerInventory, context);
    }

    @WrapOperation(method={"createResult()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/AnvilMenu;broadcastChanges()V")})
    private void updateResult_EnchantLimiter(AnvilMenu instance, Operation<Void> original) {
        ItemStack outputStack = this.resultSlots.getItem(0);
        LimitComponent limiter = (LimitComponent)outputStack.get(ItemComponentTypes.ENCHANT_LIMITER);
        if (limiter != null) {
            int limit = limiter.count();
            ItemEnchantments enchantments = (ItemEnchantments)outputStack.get(DataComponents.ENCHANTMENTS);
            if (enchantments != null && enchantments.keySet().size() > limit) {
                this.resultSlots.setItem(0, ItemStack.EMPTY);
                this.cost.set(0);
            }
        }
        original.call(new Object[]{instance});
    }
}

