/*
 * Decompiled with CFR 0.152.
 */
package net.enchant_limiter.mixin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.enchant_limiter.api.ItemComponentTypes;
import net.enchant_limiter.api.LimitComponent;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentHelper.class})
public class EnchantmentHelperMixin {
    @Inject(method={"selectEnchantment(Lnet/minecraft/util/RandomSource;Lnet/minecraft/world/item/ItemStack;ILjava/util/stream/Stream;)Ljava/util/List;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void generateEnchantments_Limited(RandomSource random, ItemStack stack, int level, Stream<Holder<Enchantment>> possibleEnchantments, CallbackInfoReturnable<List<EnchantmentInstance>> cir) {
        List selectedEnchantments;
        LimitComponent limiter = (LimitComponent)stack.get(ItemComponentTypes.ENCHANT_LIMITER);
        if (limiter != null && !(selectedEnchantments = (List)cir.getReturnValue()).isEmpty() && selectedEnchantments.size() > limiter.count()) {
            ArrayList shuffled = new ArrayList(selectedEnchantments);
            Collections.shuffle(shuffled);
            int limit = Math.min(limiter.count(), shuffled.size());
            ArrayList selected = new ArrayList(shuffled.subList(0, limit));
            cir.setReturnValue(selected);
        }
    }
}

