/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.api;

import java.util.List;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.power.GemPowerComponent;
import net.sweenus.simplyswords.power.GemPowerFiller;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;

public class SimplySwordsAPI {
    public static BattleStandardEntity spawnBattleStandard(Player user, int decayRate, String standardType, int height, int distance, String positiveEffect, String positiveEffectSecondary, int positiveEffectAmplifier, String negativeEffect, String negativeEffectSecondary, int negativeEffectAmplifier, boolean dealsDamage, boolean doesHealing) {
        BlockState state;
        ServerLevel world;
        BlockState currentState;
        if (!user.level().isClientSide() && (currentState = (world = (ServerLevel)user.level()).getBlockState(user.blockPosition().above(height).relative(user.getMotionDirection(), distance))) == (state = Blocks.AIR.defaultBlockState())) {
            world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_EARTH_ATTACK_01.get(), user.getSoundSource(), 0.4f, 0.8f);
            BattleStandardEntity banner = (BattleStandardEntity)((EntityType)EntityRegistry.BATTLESTANDARD.get()).spawn(world, user.blockPosition().above(height).relative(user.getMotionDirection(), distance), MobSpawnType.MOB_SUMMONED);
            if (banner != null) {
                banner.setDeltaMovement(0.0, -1.0, 0.0);
                banner.ownerEntity = user;
                banner.decayRate = decayRate;
                banner.standardType = standardType;
                banner.doesHealing = doesHealing;
                banner.dealsDamage = dealsDamage;
                banner.negativeEffect = negativeEffect;
                banner.negativeEffectSecondary = negativeEffectSecondary;
                banner.positiveEffect = positiveEffect;
                banner.positiveEffectSecondary = positiveEffectSecondary;
                banner.positiveEffectAmplifier = positiveEffectAmplifier;
                banner.negativeEffectAmplifier = negativeEffectAmplifier;
                banner.setCustomName((Component)Component.translatable((String)"entity.simplyswords.battlestandard.name", (Object[])new Object[]{user.getName()}));
                return banner;
            }
        }
        return null;
    }

    public static GemPowerComponent getComponent(ItemStack stack) {
        return (GemPowerComponent)stack.getOrDefault((DataComponentType)ComponentTypeRegistry.GEM_POWER.get(), (Object)GemPowerComponent.DEFAULT);
    }

    public static void postHitGemSocketLogic(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            GemPowerComponent component = SimplySwordsAPI.getComponent(stack);
            component.postHit(stack, target, attacker);
        }
    }

    public static void appendTooltipGemSocketLogic(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        GemPowerComponent component = SimplySwordsAPI.getComponent(itemStack);
        if (!component.isEmpty()) {
            tooltip.add((Component)Component.literal((String)""));
        }
        component.appendTooltip(itemStack, tooltipContext, tooltip, type);
    }

    public static void onClickedGemSocketLogic(ItemStack stack, ItemStack otherStack, Player player) {
        GemPowerFiller gemPowerFiller;
        ValidationResult<GemPowerComponent> result;
        Item item;
        GemPowerComponent component;
        if (Config.general.enableUniqueGemSockets && (component = SimplySwordsAPI.getComponent(stack)).canBeFilled() && (item = otherStack.getItem()) instanceof GemPowerFiller && (result = (gemPowerFiller = (GemPowerFiller)item).fill(otherStack, component)).isValid()) {
            stack.set((DataComponentType)ComponentTypeRegistry.GEM_POWER.get(), (Object)((GemPowerComponent)result.get()));
            player.level().playSound(null, (Entity)player, SoundEvents.ANVIL_USE, player.getSoundSource(), 1.0f, 1.0f);
            otherStack.shrink(1);
        }
    }

    public static void inventoryTickGemSocketLogic(ItemStack stack, Level world, Entity entity, int runeSocketChance, int netherSocketChance) {
        LivingEntity user;
        if (!stack.has((DataComponentType)ComponentTypeRegistry.GEM_POWER.get()) && Config.general.enableUniqueGemSockets) {
            float runeSocketRoll = (float)(Math.random() * 100.0);
            float netherSocketRoll = (float)(Math.random() * 100.0);
            stack.set((DataComponentType)ComponentTypeRegistry.GEM_POWER.get(), (Object)GemPowerComponent.createEmpty(runeSocketRoll > (float)runeSocketChance, netherSocketRoll > (float)netherSocketChance));
        }
        if (!world.isClientSide && entity instanceof LivingEntity && ((user = (LivingEntity)entity).getItemBySlot(EquipmentSlot.MAINHAND) == stack || user.getItemBySlot(EquipmentSlot.OFFHAND) == stack)) {
            GemPowerComponent component = SimplySwordsAPI.getComponent(stack);
            component.inventoryTick(stack, world, user, 0, true);
        }
    }
}

