/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.effect.HighOrbitingEffect;
import net.sweenus.simplyswords.item.custom.MagiscytheSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class MagistormEffect
extends HighOrbitingEffect {
    public MagistormEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType1((ParticleOptions)ParticleTypes.ENCHANT);
        this.setParticleType2((ParticleOptions)ParticleTypes.POOF);
        this.setParticleType3((ParticleOptions)ParticleTypes.CRIT);
        this.yOffset = 4.0f;
        this.width = 4.0f;
    }

    @Override
    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide()) {
            ServerLevel world = (ServerLevel)livingEntity.level();
            double x = livingEntity.getX();
            double y = livingEntity.getY();
            double z = livingEntity.getZ();
            double radius = Config.uniqueEffects.magiscythe.radius;
            float duration = Config.uniqueEffects.magiscythe.duration;
            int frequency = Math.max(3, 10 - amplifier);
            float spellScalingModifier = Config.uniqueEffects.magiscythe.spellScaling;
            float damage = Math.max(Config.uniqueEffects.magiscythe.damage, HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)livingEntity, "arcane"));
            DamageSource damageSource = livingEntity.damageSources().indirectMagic((Entity)livingEntity, (Entity)livingEntity);
            if (livingEntity.tickCount % frequency == 0 && livingEntity instanceof Player) {
                LivingEntity target;
                Entity randomEntity;
                Player player = (Player)livingEntity;
                AABB box = new AABB(x - radius, y - 1.0, z - radius, x + radius, y + 1.0, z + radius);
                List nearbyEntities = world.getEntities((Entity)livingEntity, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE);
                if (!nearbyEntities.isEmpty() && player.getMainHandItem().getItem() instanceof MagiscytheSwordItem && (randomEntity = (Entity)nearbyEntities.get(new Random().nextInt(nearbyEntities.size()))) instanceof LivingEntity && HelperMethods.checkFriendlyFire(target = (LivingEntity)randomEntity, (LivingEntity)player)) {
                    if (target instanceof Player) {
                        damageSource = livingEntity.damageSources().playerAttack(player);
                    }
                    target.invulnerableTime = 0;
                    HelperMethods.applyDamageWithoutKnockback(target, damageSource, damage);
                    target.invulnerableTime = 0;
                    HelperMethods.spawnRainingParticles(world, (ParticleOptions)ParticleTypes.ENCHANT, (Entity)target, 20, this.yOffset);
                    HelperMethods.spawnRainingParticles(world, (ParticleOptions)ParticleTypes.GLOW, (Entity)target, 4, this.yOffset);
                    HelperMethods.spawnOrbitParticles(world, target.position(), (ParticleOptions)ParticleTypes.GLOW, 0.5, 6);
                    player.level().playSound(null, (Entity)player, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_HOLY_SHOOT_IMPACT_03.get(), SoundSource.PLAYERS, 0.1f, 1.0f + player.getRandom().nextFloat());
                    if (new Random().nextInt(100) < 5) {
                        HelperMethods.incrementStatusEffect(livingEntity, EffectRegistry.getReference(EffectRegistry.MAGISTORM), (int)duration, 1, 10);
                    }
                }
            }
        }
        super.applyEffectTick(livingEntity, amplifier);
        return true;
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return super.shouldApplyEffectTickThisTick(duration, amplifier);
    }
}

