/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.client.api.SimplySwordsClientAPI;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public abstract class UniqueSwordItem
extends SwordItem {
    String iRarity = "UNIQUE";

    public UniqueSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings.fireResistant());
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 0;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        SimplySwordsAPI.inventoryTickGemSocketLogic(stack, world, entity, 50, 50);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        SimplySwordsAPI.onClickedGemSocketLogic(stack, otherStack, player);
        return false;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            HelperMethods.playHitSounds(attacker, target);
            SimplySwordsAPI.postHitGemSocketLogic(stack, target, attacker);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public Component getName(ItemStack stack) {
        if (this.getDefaultInstance().is((Item)ItemsRegistry.AWAKENED_LICHBLADE.get()) || this.getDefaultInstance().is((Item)ItemsRegistry.HARBINGER.get()) || this.getDefaultInstance().is((Item)ItemsRegistry.SUNFIRE.get()) || this.getDefaultInstance().is((Item)ItemsRegistry.MAGISPEAR.get()) || this.getDefaultInstance().is((Item)ItemsRegistry.MAGIBLADE.get()) || this.getDefaultInstance().is((Item)ItemsRegistry.MAGISCYTHE.get())) {
            this.iRarity = "LEGENDARY";
            return Component.translatable((String)this.getDescriptionId(stack)).setStyle(Styles.LEGENDARY);
        }
        if (this.iRarity.equals("UNIQUE")) {
            return Component.translatable((String)this.getDescriptionId(stack)).setStyle(Styles.UNIQUE);
        }
        return Component.translatable((String)this.getDescriptionId(stack)).setStyle(Styles.COMMON);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        this.generateDynamicTooltip(itemStack, tooltipContext, tooltip, type);
    }

    protected ResourceLocation getConfigPath() {
        return ResourceLocation.parse((String)("simplyswords.unique_effects." + this.asItem().builtInRegistryHolder().key().location().getPath()));
    }

    protected void generateDynamicTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        SimplySwordsClientAPI.generateDynamicTooltip(itemStack, tooltipContext, tooltip, type, "simplyswords", "oracle_index:books/simplyswords/weapon-types", "oracle_index:books/simplyswords/unique-weapons", "oracle_index:books/simplyswords/runic-powers", this.getConfigPath());
    }
}

