/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.TwoHandedWeapon;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.component.StoredChargeComponent;
import net.sweenus.simplyswords.item.component.TargetedLocationComponent;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.AbilityMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class LichbladeSwordItem
extends UniqueSwordItem
implements TwoHandedWeapon {
    LivingEntity abilityTarget;

    public LichbladeSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        HelperMethods.playHitSounds(attacker, target);
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        if (itemStack.is((Item)ItemsRegistry.SLUMBERING_LICHBLADE.get())) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        LivingEntity abilityTarget = (LivingEntity)HelperMethods.getTargetedEntity((Entity)user, Config.uniqueEffects.lichblade.range);
        if (abilityTarget != null) {
            abilityTarget.addEffect(new MobEffectInstance(MobEffects.GLOWING, 10, 0), (Entity)user);
            world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.DARK_SWORD_ENCHANT.get(), user.getSoundSource(), 0.5f, 0.5f);
            itemStack.set((DataComponentType)ComponentTypeRegistry.TARGETED_LOCATION.get(), (Object)new TargetedLocationComponent(abilityTarget.getUUID(), user.getX(), user.getY(), user.getZ()));
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (world.isClientSide) {
            return;
        }
        TargetedLocationComponent targetLocation = (TargetedLocationComponent)stack.getOrDefault((DataComponentType)ComponentTypeRegistry.TARGETED_LOCATION.get(), (Object)TargetedLocationComponent.DEFAULT);
        LivingEntity abilityTarget = targetLocation.getEntity((ServerLevel)world);
        if (user.getItemBySlot(EquipmentSlot.MAINHAND) == stack && abilityTarget != null) {
            int maxDuration = Config.uniqueEffects.lichblade.duration;
            int radius = Config.uniqueEffects.lichblade.radius;
            if (stack.is((Item)ItemsRegistry.AWAKENED_LICHBLADE.get())) {
                if (abilityTarget.isDeadOrDying() || abilityTarget == user || remainingUseTicks < maxDuration) {
                    stack.set((DataComponentType)ComponentTypeRegistry.TARGETED_LOCATION.get(), (Object)targetLocation.setTarget((Entity)user));
                    abilityTarget = user;
                    if (user.distanceToSqr(targetLocation.lastX(), targetLocation.lastY(), targetLocation.lastZ()) < (double)radius) {
                        int damageTracker = ((StoredChargeComponent)stack.getOrDefault((DataComponentType)ComponentTypeRegistry.STORED_CHARGE.get(), (Object)StoredChargeComponent.DEFAULT)).charge();
                        user.setAbsorptionAmount(Math.min(Config.uniqueEffects.abilityAbsorptionCap, user.getAbsorptionAmount() + Math.min((float)damageTracker / 2.0f, (float)Config.uniqueEffects.lichblade.absorptionCap)));
                        user.releaseUsingItem();
                        world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.DARK_SWORD_SPELL.get(), user.getSoundSource(), 0.04f, 0.5f);
                    }
                }
            } else if (stack.is((Item)ItemsRegistry.WAKING_LICHBLADE.get()) && (abilityTarget.isDeadOrDying() || remainingUseTicks < maxDuration)) {
                user.releaseUsingItem();
            }
            double lastX = targetLocation.lastX();
            double lastY = targetLocation.lastY();
            double lastZ = targetLocation.lastZ();
            if (user.tickCount % 5 == 0) {
                double targetX = abilityTarget.getX();
                double targetY = abilityTarget.getY();
                double targetZ = abilityTarget.getZ();
                if (targetX > lastX) {
                    lastX += 1.0;
                }
                if (targetX < lastX) {
                    lastX -= 1.0;
                }
                if (targetZ > lastZ) {
                    lastZ += 1.0;
                }
                if (targetZ < lastZ) {
                    lastZ -= 1.0;
                }
                if (targetY > lastY) {
                    lastY += 1.0;
                }
                if (targetY < lastY) {
                    lastY -= 1.0;
                }
            }
            stack.set((DataComponentType)ComponentTypeRegistry.TARGETED_LOCATION.get(), (Object)new TargetedLocationComponent(abilityTarget.getUUID(), lastX, lastY, lastZ));
            float abilityDamage = HelperMethods.spellScaledDamage("soul", (Entity)user, Config.uniqueEffects.lichblade.spellScaling, Config.uniqueEffects.lichblade.damage);
            float healAmount = Config.uniqueEffects.lichblade.heal;
            AbilityMethods.tickAbilitySoulAnguish(stack, world, user, abilityDamage, radius, lastX, lastY, lastZ, healAmount, abilityTarget);
        }
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return Config.uniqueEffects.lichblade.duration * 2;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        TargetedLocationComponent targetLocation = (TargetedLocationComponent)stack.get((DataComponentType)ComponentTypeRegistry.TARGETED_LOCATION.get());
        if (!world.isClientSide && user instanceof Player) {
            Player player = (Player)user;
            if (targetLocation != null && ((ServerLevel)world).getEntity(targetLocation.uuid()) != null) {
                player.getCooldowns().addCooldown(stack.getItem(), Config.uniqueEffects.lichblade.cooldown);
            }
        }
        stack.set((DataComponentType)ComponentTypeRegistry.STORED_CHARGE.get(), null);
        stack.set((DataComponentType)ComponentTypeRegistry.TARGETED_LOCATION.get(), null);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity user, int slot, boolean selected) {
        if (!user.level().isClientSide() && user instanceof LivingEntity) {
            LivingEntity livingUser = (LivingEntity)user;
            if (livingUser.tickCount % 35 == 0 && livingUser.getItemBySlot(EquipmentSlot.MAINHAND) == stack && !livingUser.isUsingItem()) {
                float abilityDamage = HelperMethods.spellScaledDamage("soul", user, Config.uniqueEffects.lichblade.spellScaling, Config.uniqueEffects.lichblade.damage);
                int radius = Config.uniqueEffects.lichblade.radius;
                AABB box = new AABB(livingUser.getX() + (double)radius, livingUser.getY() + (double)radius, livingUser.getZ() + (double)radius, livingUser.getX() - (double)radius, livingUser.getY() - (double)radius, livingUser.getZ() - (double)radius);
                for (Entity entity : world.getEntities((Entity)livingUser, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity le = (LivingEntity)entity;
                    if (!HelperMethods.checkFriendlyFire((LivingEntity)entity, livingUser)) continue;
                    le.hurt(livingUser.damageSources().indirectMagic(user, user), abilityDamage);
                }
                world.playSound(null, (Entity)livingUser, (SoundEvent)SoundRegistry.DARK_SWORD_BLOCK.get(), livingUser.getSoundSource(), 0.1f, 0.2f);
                double xPos = livingUser.getX() - (double)(radius + 1);
                double yPos = livingUser.getY();
                double zPos = livingUser.getZ() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.SCULK_SOUL, xPos + (double)i + (double)choose, yPos, zPos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.SOUL, xPos + (double)i + (double)choose, yPos + 0.1, zPos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.MYCELIUM, xPos + (double)i + (double)choose, yPos + 2.0, zPos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        HelperMethods.createFootfalls(user, stack, world, (ParticleOptions)ParticleTypes.SOUL, (ParticleOptions)ParticleTypes.SOUL, (ParticleOptions)ParticleTypes.MYCELIUM, true);
        super.inventoryTick(stack, world, user, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        if (itemStack.is((Item)ItemsRegistry.SLUMBERING_LICHBLADE.get())) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.lichbladesworditem.tooltip1").setStyle(Styles.ABILITY));
        } else if (itemStack.is((Item)ItemsRegistry.WAKING_LICHBLADE.get())) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.lichbladesworditem.tooltip1.2").setStyle(Styles.ABILITY));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.lichbladesworditem.tooltip1.3").setStyle(Styles.ABILITY));
        }
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.lichbladesworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.lichbladesworditem.tooltip3").setStyle(Styles.TEXT));
        if (!itemStack.is((Item)ItemsRegistry.SLUMBERING_LICHBLADE.get())) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclickheld").setStyle(Styles.RIGHT_CLICK));
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.lichbladesworditem.tooltip4").setStyle(Styles.TEXT));
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.lichbladesworditem.tooltip5").setStyle(Styles.TEXT));
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.lichbladesworditem.tooltip6").setStyle(Styles.TEXT));
            if (itemStack.is((Item)ItemsRegistry.AWAKENED_LICHBLADE.get())) {
                tooltip.add((Component)Component.literal((String)""));
                tooltip.add((Component)Component.translatable((String)"item.simplyswords.lichbladesworditem.tooltip7").setStyle(Styles.TEXT));
                tooltip.add((Component)Component.translatable((String)"item.simplyswords.lichbladesworditem.tooltip8").setStyle(Styles.TEXT));
                tooltip.add((Component)Component.translatable((String)"item.simplyswords.lichbladesworditem.tooltip9").setStyle(Styles.TEXT));
            }
        }
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "soul");
    }

    @Override
    protected ResourceLocation getConfigPath() {
        return ResourceLocation.parse((String)"simplyswords.unique_effects.lichblade");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int absorptionCap;
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedFloat.Restrict(min=0.0f)
        public float heal;
        @ValidatedInt.Restrict(min=1)
        public int radius;
        @ValidatedDouble.Restrict(min=1.0)
        public double range;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> ItemsRegistry.SLUMBERING_LICHBLADE.get();
            supplierArray[1] = () -> ItemsRegistry.WAKING_LICHBLADE.get();
            supplierArray[2] = () -> ItemsRegistry.AWAKENED_LICHBLADE.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.absorptionCap = 8;
            this.cooldown = 700;
            this.damage = 6.0f;
            this.duration = 200;
            this.heal = 0.5f;
            this.radius = 3;
            this.range = 22.0;
            this.spellScaling = 1.6f;
        }
    }
}

