/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import dev.architectury.platform.Platform;
import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class RibboncleaverSwordItem
extends UniqueSwordItem {
    public RibboncleaverSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        int skillCooldown = Config.uniqueEffects.ribboncleaver.cooldown;
        int resilienceAmplifier = Config.uniqueEffects.ribboncleaver.resilienceAmplifier;
        world.playSound(null, user.blockPosition(), (SoundEvent)SoundRegistry.ELEMENTAL_BOW_EARTH_SHOOT_IMPACT_03.get(), user.getSoundSource(), 0.4f, 1.3f);
        if (user.onGround()) {
            world.playSound(null, user.blockPosition(), (SoundEvent)SoundRegistry.OBJECT_IMPACT_THUD_REPEAT.get(), user.getSoundSource(), 0.5f, 1.2f);
        }
        user.setDeltaMovement(user.getLookAngle().scale(1.7));
        user.setDeltaMovement(user.getDeltaMovement().x, 0.0, user.getDeltaMovement().z);
        user.hurtMarked = true;
        user.addEffect(new MobEffectInstance(EffectRegistry.getReference(EffectRegistry.RIBBONCLEAVE), 60, 0, false, false, true));
        user.addEffect(new MobEffectInstance(EffectRegistry.getReference(EffectRegistry.RESILIENCE), 15, resilienceAmplifier, false, false, true));
        user.getCooldowns().addCooldown((Item)this, skillCooldown);
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        if (entity.onGround() && Platform.isModLoaded((String)"bettercombat") && HelperMethods.isWalking(entity) && entity instanceof Player && (player = (Player)entity).getMainHandItem().is((Item)ItemsRegistry.RIBBONCLEAVER.get())) {
            BlockState blockState = entity.getBlockStateOn();
            BlockParticleOption particleEffect = new BlockParticleOption(ParticleTypes.BLOCK, blockState);
            double bodyRadians = Math.toRadians(entity.getVisualRotationYInDegrees() + 180.0f);
            Vec3 backwardDirection = new Vec3(-Math.sin(bodyRadians), 0.0, Math.cos(bodyRadians)).scale(1.1);
            double strafeRadians = Math.toRadians(entity.getVisualRotationYInDegrees() + 90.0f);
            Vec3 strafeDirection = new Vec3(-Math.sin(strafeRadians), 0.0, Math.cos(strafeRadians));
            Vec3 movementVector = entity.getDeltaMovement();
            double strafeMagnitude = movementVector.dot(strafeDirection.normalize());
            double pivotOffsetFactor = 3.0;
            Vec3 pivotOffset = strafeDirection.scale(strafeMagnitude * pivotOffsetFactor);
            Vec3 adjustedBackwardDirection = backwardDirection.subtract(pivotOffset);
            Vec3 handPosOffset = entity.getHandHoldingItemAngle(stack.getItem());
            double particleX = entity.getX() + adjustedBackwardDirection.x + handPosOffset.x();
            double particleY = entity.getY() + handPosOffset.y();
            double particleZ = entity.getZ() + adjustedBackwardDirection.z + handPosOffset.z();
            particleY = entity.onGround() ? entity.getY() : particleY;
            world.addParticle((ParticleOptions)particleEffect, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
            world.addParticle((ParticleOptions)ParticleTypes.POOF, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ribboncleaversworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ribboncleaversworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ribboncleaversworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ribboncleaversworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ribboncleaversworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ribboncleaversworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ribboncleaversworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ribboncleaversworditem.tooltip8").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ribboncleaversworditem.tooltip9").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ribboncleaversworditem.tooltip10").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedDouble.Restrict(min=0.0)
        public double damageBonusPercent;
        @ValidatedInt.Restrict(min=0)
        public int resilienceAmplifier;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.RIBBONCLEAVER.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.cooldown = 40;
            this.damageBonusPercent = 0.95;
            this.resilienceAmplifier = 1;
        }
    }
}

