/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class TempestSwordItem
extends UniqueSwordItem {
    public TempestSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            int vortexMaxStacks = Config.uniqueEffects.tempest.maxStacks;
            ServerLevel serverWorld = (ServerLevel)attacker.level();
            HelperMethods.playHitSounds(attacker, target);
            ArrayList<SoundEvent> sounds = new ArrayList<SoundEvent>();
            sounds.add((SoundEvent)SoundRegistry.SPELL_FIRE.get());
            sounds.add((SoundEvent)SoundRegistry.ELEMENTAL_SWORD_WATER_ATTACK_03.get());
            sounds.add((SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get());
            sounds.add((SoundEvent)SoundRegistry.ELEMENTAL_BOW_WATER_SHOOT_IMPACT_02.get());
            ArrayList<SimpleParticleType> particles = new ArrayList<SimpleParticleType>();
            particles.add(ParticleTypes.SMOKE);
            particles.add(ParticleTypes.CLOUD);
            particles.add(ParticleTypes.SMOKE);
            particles.add(ParticleTypes.CLOUD);
            ArrayList<Holder<MobEffect>> status = new ArrayList<Holder<MobEffect>>();
            status.add(EffectRegistry.getReference(EffectRegistry.FIRE_VORTEX));
            status.add(EffectRegistry.getReference(EffectRegistry.FROST_VORTEX));
            status.add(EffectRegistry.getReference(EffectRegistry.FIRE_VORTEX));
            status.add(EffectRegistry.getReference(EffectRegistry.FROST_VORTEX));
            int random = attacker.getRandom().nextInt(3);
            SoundEvent soundSelect = (SoundEvent)sounds.get(random);
            ParticleOptions particleSelect = (ParticleOptions)particles.get(random);
            Holder statusSelect = (Holder)status.get(random);
            int particleCount = 10;
            HelperMethods.spawnWaistHeightParticles(serverWorld, particleSelect, (Entity)attacker, (Entity)target, particleCount);
            serverWorld.playSound(null, attacker.blockPosition(), soundSelect, attacker.getSoundSource(), 0.2f, 1.3f);
            SimplySwordsStatusEffectInstance effect = HelperMethods.incrementSimplySwordsStatusEffect(target, (Holder<MobEffect>)statusSelect, 500, 1, vortexMaxStacks);
            effect.setSourceEntity(attacker);
            effect.setAdditionalData((int)HelperMethods.getEntityAttackDamage(attacker) / 3);
            target.addEffect((MobEffectInstance)effect);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!user.level().isClientSide() && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            int vortexMaxSize = Config.uniqueEffects.tempest.maxSize;
            int vortexDuration = Config.uniqueEffects.tempest.duration;
            int skillCooldown = 200;
            AABB box = HelperMethods.createBox((Entity)user, 15.0);
            boolean soundHasPlayed = false;
            for (Entity entity : serverWorld.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                LivingEntity le;
                if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, (LivingEntity)user) || !le.hasEffect(EffectRegistry.getReference(EffectRegistry.FIRE_VORTEX)) || !le.hasEffect(EffectRegistry.getReference(EffectRegistry.FROST_VORTEX))) continue;
                MobEffectInstance frostVortex = le.getEffect(EffectRegistry.getReference(EffectRegistry.FROST_VORTEX));
                MobEffectInstance fireVortex = le.getEffect(EffectRegistry.getReference(EffectRegistry.FIRE_VORTEX));
                int totalAmplifier = 0;
                if (fireVortex != null && frostVortex != null) {
                    totalAmplifier = fireVortex.getAmplifier() + frostVortex.getAmplifier();
                }
                int particleCount = 10;
                HelperMethods.spawnWaistHeightParticles(serverWorld, (ParticleOptions)ParticleTypes.CLOUD, (Entity)le, (Entity)user, particleCount);
                if (!soundHasPlayed) {
                    serverWorld.playSound(null, le.blockPosition(), (SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_22.get(), le.getSoundSource(), 0.4f, 1.3f);
                    soundHasPlayed = true;
                }
                SimplySwordsStatusEffectInstance status = HelperMethods.incrementSimplySwordsStatusEffect((LivingEntity)user, EffectRegistry.getReference(EffectRegistry.ELEMENTAL_VORTEX), vortexDuration, totalAmplifier, vortexMaxSize);
                status.setAdditionalData(Math.max(1, totalAmplifier));
                status.setSourceEntity((LivingEntity)user);
                le.removeEffect(EffectRegistry.getReference(EffectRegistry.FIRE_VORTEX));
                le.removeEffect(EffectRegistry.getReference(EffectRegistry.FROST_VORTEX));
                user.getCooldowns().addCooldown((Item)this, skillCooldown);
            }
        }
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.BUBBLE, (ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, (ParticleOptions)ParticleTypes.BUBBLE_POP, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.tempestsworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.tempestsworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.tempestsworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.tempestsworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.tempestsworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.tempestsworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.tempestsworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.tempestsworditem.tooltip8").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.tempestsworditem.tooltip9").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.tempestsworditem.tooltip10").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.tempestsworditem.tooltip11").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "frost_fire");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedInt.Restrict(min=1)
        public int maxSize;
        @ValidatedInt.Restrict(min=1)
        public int maxStacks;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.TEMPEST.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.duration = 1200;
            this.maxSize = 30;
            this.maxStacks = 10;
            this.spellScaling = 0.3f;
        }
    }
}

