/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.TwoHandedWeapon;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class TwistedBladeItem
extends UniqueSwordItem
implements TwoHandedWeapon {
    private static int stepMod = 0;

    public TwistedBladeItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            ServerLevel world = (ServerLevel)attacker.level();
            int hitChance = Config.uniqueEffects.twisted_blade.chance;
            int duration = Config.uniqueEffects.twisted_blade.duration;
            int maxStacks = Config.uniqueEffects.twisted_blade.maxStacks;
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.getRandom().nextInt(100) <= hitChance) {
                if (attacker.hasEffect(MobEffects.DIG_SPEED)) {
                    int a = attacker.getEffect(MobEffects.DIG_SPEED).getAmplifier() + 1;
                    world.playSound(null, (Entity)attacker, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_HOLY_SHOOT_IMPACT_02.get(), attacker.getSoundSource(), 0.3f, 1.0f + (float)a / 10.0f);
                    if (attacker.getEffect(MobEffects.DIG_SPEED).getAmplifier() < maxStacks) {
                        attacker.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, duration, a), (Entity)attacker);
                    } else {
                        attacker.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, duration, a - 1), (Entity)attacker);
                    }
                } else {
                    attacker.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, duration, 1), (Entity)attacker);
                }
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (user.hasEffect(MobEffects.DIG_SPEED)) {
            int strength_tier = Config.uniqueEffects.twisted_blade.strengthTier;
            int a = user.getEffect(MobEffects.DIG_SPEED).getAmplifier() * 20;
            user.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, a, strength_tier), (Entity)user);
            user.swing(hand);
            user.removeEffect(MobEffects.DIG_SPEED);
            world.playSound(null, user.blockPosition(), (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_03.get(), user.getSoundSource(), 0.5f, 1.5f);
        }
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.ASH, (ParticleOptions)ParticleTypes.ASH, (ParticleOptions)ParticleTypes.ASH, false);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ferocitysworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ferocitysworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ferocitysworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ferocitysworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ferocitysworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.ferocitysworditem.tooltip6").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance;
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedInt.Restrict(min=0)
        public int maxStacks;
        @ValidatedInt.Restrict(min=0)
        public int strengthTier;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.TWISTED_BLADE.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 75;
            this.duration = 100;
            this.maxStacks = 15;
            this.strengthTier = 2;
        }
    }
}

