/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power.powers;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.power.NetherGemPower;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class BerserkPower
extends NetherGemPower {
    public BerserkPower() {
        super(false);
    }

    @Override
    public void postHit(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int amp;
        int n = amp = HelperMethods.isUniqueTwohanded(stack) ? 4 : 2;
        if (attacker.getArmorValue() < 10) {
            target.setHealth(target.getHealth() - (float)amp);
            attacker.heal((float)amp / 2.0f);
        }
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, boolean isRunic) {
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.netherfused_power.berserk").setStyle(Styles.NETHERFUSED));
        if (TooltipUtils.shouldDisplayTooltip(itemStack, null)) {
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.netherfused_power.berserk.description")).setStyle(Styles.NETHERFUSED_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.netherfused_power.berserk.description2")).setStyle(Styles.NETHERFUSED_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.netherfused_power.berserk.description3")).setStyle(Styles.NETHERFUSED_DESCRIPTION));
        }
    }
}

