/*
 * Decompiled with CFR 0.152.
 */
package com.Zhu_Yii.zylob.shader;

import com.Zhu_Yii.zylob.config.lobConfig;

public class ColorEnhancement {
    public static float[] applyEnhancedBrightnessBoost(float r, float g, float b) {
        float[] hsv = ColorEnhancement.rgbToHsv(r, g, b);
        float boostFactor = ((Double)lobConfig.COLOR_EN.get()).floatValue() - 1.0f;
        float avg = (r + g + b) / 3.0f;
        float variance = ((r - avg) * (r - avg) + (g - avg) * (g - avg) + (b - avg) * (b - avg)) / 3.0f;
        float stdDev = (float)Math.sqrt(variance);
        float valueBoost = ColorEnhancement.calculateValueBoost(hsv[2], boostFactor);
        float saturationBoost = stdDev < 0.06f ? 1.0f : ColorEnhancement.calculateSaturationBoost(hsv[1], boostFactor);
        hsv[1] = Math.min(1.0f, hsv[1] * saturationBoost);
        hsv[2] = Math.min(1.0f, hsv[2] * valueBoost);
        return ColorEnhancement.hsvToRgb(hsv[0], hsv[1], hsv[2]);
    }

    private static float calculateSaturationBoost(float saturation, float boostFactor) {
        if (saturation < 0.3f) {
            return 1.0f + boostFactor * 1.5f;
        }
        if (saturation > 0.7f) {
            return 1.0f + boostFactor * 0.3f;
        }
        return 1.0f + boostFactor;
    }

    private static float calculateValueBoost(float value, float boostFactor) {
        if (value < 0.3f) {
            return 1.0f + boostFactor * 1.8f;
        }
        if (value > 0.7f) {
            return 1.0f + boostFactor * 0.8f;
        }
        return 1.0f + boostFactor;
    }

    private static float[] rgbToHsv(float r, float g, float b) {
        float min = Math.min(Math.min(r, g), b);
        float max = Math.max(Math.max(r, g), b);
        float delta = max - min;
        float h = 0.0f;
        float s = 0.0f;
        if (delta != 0.0f) {
            s = delta / max;
            h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
            if ((h *= 60.0f) < 0.0f) {
                h += 360.0f;
            }
        }
        return new float[]{h / 360.0f, s, max};
    }

    private static float[] hsvToRgb(float h, float s, float v) {
        h *= 360.0f;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (s == 0.0f) {
            g = b = v;
            r = b;
        } else {
            float hf = h / 60.0f;
            int i = (int)Math.floor(hf);
            float f = hf - (float)i;
            float p = v * (1.0f - s);
            float q = v * (1.0f - s * f);
            float t = v * (1.0f - s * (1.0f - f));
            switch (i) {
                case 0: {
                    r = v;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = v;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = v;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = v;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = v;
                    break;
                }
                case 5: {
                    r = v;
                    g = p;
                    b = q;
                }
            }
        }
        return new float[]{r, g, b};
    }
}

