/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.GaugeChunkWidget;
import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import com.st0x0ef.stellaris.common.blocks.entities.machines.WaterSeparatorBlockEntity;
import com.st0x0ef.stellaris.common.menus.WaterSeparatorMenu;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.FluidStorage;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WaterSeparatorScreen
extends AbstractContainerScreen<WaterSeparatorMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocationUtils.guiTexture("water_separator");
    private final WaterSeparatorBlockEntity blockEntity = ((WaterSeparatorMenu)this.getMenu()).getBlockEntity();
    private GaugeChunkWidget ingredientTankGauge;
    private GaugeWidget hydrogenTankGauge;
    private GaugeWidget oxygenTankGauge;
    private GaugeWidget energyGauge;

    public WaterSeparatorScreen(WaterSeparatorMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 180;
        this.imageHeight = 224;
        this.titleLabelX = (180 - Minecraft.getInstance().font.width(title.getString())) / 2;
        this.titleLabelY = 2;
    }

    protected void init() {
        super.init();
        if (this.blockEntity == null) {
            return;
        }
        SingleFluidStorage ingredientTank = this.blockEntity.getIngredientTank();
        this.ingredientTankGauge = new GaugeChunkWidget(this.leftPos + 53, this.topPos + 54, 76, 46, (Component)Component.translatable((String)"stellaris.screen.water"), GUISprites.WATER_OVERLAY, GUISprites.WATER_SEPARATOR_OVERLAY, ingredientTank.getTankCapacity(0), GaugeWidget.Direction4.DOWN_UP);
        this.addRenderableWidget((GuiEventListener)this.ingredientTankGauge);
        FluidStorage resultTanks = this.blockEntity.getResultTanks();
        this.hydrogenTankGauge = new GaugeWidget(this.leftPos + 22, this.topPos + 54, 12, 46, (Component)Component.translatable((String)"stellaris.screen.hydrogen"), GUISprites.HYDROGEN_OVERLAY, GUISprites.FLUID_TANK_OVERLAY, resultTanks.getTankCapacity(0), GaugeWidget.Direction4.UP_DOWN);
        this.addRenderableWidget((GuiEventListener)this.hydrogenTankGauge);
        this.oxygenTankGauge = new GaugeWidget(this.leftPos + 146, this.topPos + 54, 12, 46, (Component)Component.translatable((String)"stellaris.screen.oxygen"), GUISprites.OXYGEN_OVERLAY, GUISprites.FLUID_TANK_OVERLAY, resultTanks.getTankCapacity(1), GaugeWidget.Direction4.UP_DOWN);
        this.addRenderableWidget((GuiEventListener)this.oxygenTankGauge);
        this.energyGauge = new GaugeWidget(this.leftPos + 68, this.topPos + 20, 44, 6, (Component)Component.translatable((String)"stellaris.screen.energyContainer"), GUISprites.SIDEWAYS_ENERGY_FULL, null, this.blockEntity.getEnergy(null).getMaxEnergy(), GaugeWidget.Direction4.LEFT_RIGHT);
        this.addRenderableWidget((GuiEventListener)this.energyGauge);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.blockEntity == null) {
            return;
        }
        this.ingredientTankGauge.updateAmount((int)this.blockEntity.getIngredientTank().getFluidValueInTank());
        this.hydrogenTankGauge.updateAmount((int)this.blockEntity.getResultTanks().getFluidValueInTank(0));
        this.oxygenTankGauge.updateAmount((int)this.blockEntity.getResultTanks().getFluidValueInTank(1));
        this.energyGauge.updateAmount(this.blockEntity.getEnergy(null).getEnergy());
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        this.ingredientTankGauge.renderTooltip(guiGraphics, x, y, this.font);
        this.hydrogenTankGauge.renderTooltip(guiGraphics, x, y, this.font);
        this.oxygenTankGauge.renderTooltip(guiGraphics, x, y, this.font);
        this.energyGauge.renderTooltip(guiGraphics, x, y, this.font);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 5726575, false);
    }
}

