/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks;

import com.mojang.serialization.MapCodec;
import com.st0x0ef.stellaris.common.registry.BlocksRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class MoonVine
extends GrowingPlantHeadBlock
implements BonemealableBlock,
CaveVines {
    public static final MapCodec<CaveVinesBlock> CODEC = MoonVine.simpleCodec(CaveVinesBlock::new);
    private static final float CHANCE_OF_BERRIES_ON_GROWTH = 0.11f;

    public MapCodec<CaveVinesBlock> codec() {
        return CODEC;
    }

    public MoonVine(BlockBehaviour.Properties properties) {
        super(properties, Direction.DOWN, SHAPE, false, 0.1);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource random) {
        return 1;
    }

    protected boolean canGrowInto(BlockState state) {
        return state.isAir();
    }

    protected Block getBodyBlock() {
        return (Block)BlocksRegistry.MOON_VINES_PLANT.get();
    }

    protected BlockState updateBodyAfterConvertedFromHead(BlockState head, BlockState body) {
        return (BlockState)body.setValue((Property)BERRIES, (Comparable)((Boolean)head.getValue((Property)BERRIES)));
    }

    protected BlockState getGrowIntoState(BlockState state, RandomSource random) {
        return (BlockState)super.getGrowIntoState(state, random).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(random.nextFloat() < 0.11f));
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ItemsRegistry.MOON_BERRIES.get());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return MoonVine.use((Entity)player, state, level, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BERRIES});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)BERRIES) == false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true)), 2);
    }

    public static InteractionResult use(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)BERRIES)).booleanValue()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistry.MOON_BERRIES.get(), 1));
            float f = Mth.randomBetween((RandomSource)level.random, (float)0.8f, (float)1.2f);
            level.playSound(null, pos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, f);
            BlockState blockState = (BlockState)state.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, blockState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockState));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

